% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/no_transform.R
\name{no_transform}
\alias{no_transform}
\alias{predict.no_transform}
\alias{print.no_transform}
\title{Identity transformation}
\usage{
no_transform(x, warn = TRUE, ...)

\method{predict}{no_transform}(object, newdata = NULL, inverse = FALSE, ...)

\method{print}{no_transform}(x, ...)
}
\arguments{
\item{x}{A vector}

\item{warn}{Should a warning result from infinite values?}

\item{...}{additional arguments}

\item{object}{an object of class 'no_transform'}

\item{newdata}{a vector of data to be (potentially reverse) transformed}

\item{inverse}{if TRUE, performs reverse transformation}
}
\value{
A list of class \code{no_transform} with elements
  \item{x.t}{transformed original data} 
  \item{x}{original data}
  \item{n}{number of nonmissing observations}
  \item{norm_stat}{Pearson's P / degrees of freedom} 

  The \code{predict} function returns the numeric value of the transformation
  performed on new data, and allows for the inverse transformation as well.
}
\description{
Perform an identity transformation. Admittedly it seems odd to
  have a dedicated function to essentially do I(x), but it makes sense to
  keep the same syntax as the other transformations so it plays nicely
  with them. As a benefit, the bestNormalize function will also show
  a comparable normalization statistic for the untransformed data.
}
\details{
\code{no_transform} creates a identity transformation object 
  that can be applied to new data via the \code{predict} function.
}
\examples{
x <- rgamma(100, 1, 1)

no_transform_obj <- no_transform(x)
no_transform_obj
p <- predict(no_transform_obj)
x2 <- predict(no_transform_obj, newdata = p, inverse = TRUE)

all.equal(x2, x)

}
