% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betafunctions.R
\name{Beta.gfx.poly.qdf}
\alias{Beta.gfx.poly.qdf}
\title{Coordinate Generation for Marking an Area Under the Curve for the Beta Quantile Density Distribution.}
\usage{
Beta.gfx.poly.qdf(from, to, by, alpha, beta, l = 0, u = 1)
}
\arguments{
\item{from}{The point of the \code{x}-axis from where to start producing \code{y}-quantile values.}

\item{to}{The point of the \code{x}-axis to where \code{y}-quantile values are to be produced.}

\item{by}{The resolution (or spacing) at which to produce \code{y}-density values.}

\item{alpha}{The alpha shape-parameter value for the Standard Beta probability distribution.}

\item{beta}{The beta shape-parameter for the Standard Beta probability distribution.}

\item{l}{The lower-bound location parameter of the Beta distribution.}

\item{u}{The upper-bound location parameter of the Beta distribution.}
}
\value{
A two-column matrix with quantile-values of \code{y} to plot against corresponding location values of \code{x}.
}
\description{
Plotting tool, producing a two-column matrix with values of \code{y} corresponding to locations on \code{x}. Useful for shading areas under the curve when tracing the line for the Beta probability quantile functions.
}
\examples{
# To box in an area under a four-parameter Beta quantile distribution with
# location parameters l = .25 and u = 75, and shape parameters alpha = 5 and
# beta = 3, from .4 to .6:
plot(NULL, xlim = c(0, 1), ylim = c(0, 1))
coords <- Beta.gfx.poly.qdf(from = 0.4, to = 0.6, by = 0.001, alpha = 5,
beta = 3, l = 0.25, u = 0.75)
polygon(coords)
}
