% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sem.R
\name{semv}
\alias{semv}
\alias{semv_open}
\alias{semv_post}
\alias{semv_wait}
\alias{semv_unlink}
\title{POSIX-style System V Semaphores}
\usage{
semv_open(value = 0)

semv_post(sid, undo = TRUE)

semv_wait(sid, undo = TRUE)

semv_unlink(sid)
}
\arguments{
\item{value}{the initial value of the semaphore to create (\code{>= 0}).}

\item{sid}{the semaphore id as returned by \code{semv_open}.}

\item{undo}{should the operations (decrement/increment) on the semaphore be
undone on process termination. This feature is probably the main reason to
prefer System V semaphores to POSIX ones.}
}
\value{
For \code{semv_open}, an object of class "semv", which is an integer
  referring to the System V semaphore. All other functions return \code{NULL}
  invisibly and are called for their side effects.
}
\description{
Mimic the POSIX semaphore API with System V semaphores.
}
\section{Windows Support}{
 Not supported on Windows.
}

\section{Lifecycle}{

  \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options:
  alt='[Experimental]'}}}{\strong{[Experimental]}}
}

