% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ptbf01.R
\name{ptbf01}
\alias{ptbf01}
\title{Cumulative distribution function of the t-test Bayes factor}
\usage{
ptbf01(
  k,
  n,
  n1 = n,
  n2 = n,
  null = 0,
  plocation = 0,
  pscale = 1/sqrt(2),
  pdf = 1,
  dpm = plocation,
  dpsd = pscale,
  type = c("two.sample", "one.sample", "paired"),
  alternative = c("two.sided", "less", "greater"),
  lower.tail = TRUE,
  drange = "adaptive",
  ...
)
}
\arguments{
\item{k}{Bayes factor threshold}

\item{n}{Sample size (per group)}

\item{n1}{Sample size in group 1 (only required for two-sample \eqn{t}-test
with unequal group sizes)}

\item{n2}{Sample size in group 2 (only required for two-sample \eqn{t}-test
with unequal group sizes)}

\item{null}{Standardized mean difference under the point null hypothesis.
Defaults to \code{0}}

\item{plocation}{\eqn{t} prior location. Defaults to \code{0}}

\item{pscale}{\eqn{t} prior scale. Defaults to \code{1/sqrt(2)}}

\item{pdf}{\eqn{t} prior degrees of freedom. Defaults to \code{1} (a Cauchy
prior)}

\item{dpm}{Mean of the normal design prior assigned to the standardized mean
difference. Defaults to the analysis prior location}

\item{dpsd}{Standard deviation of the normal design prior assigned to the
standardized mean difference. Set to \code{0} to obtain a point prior at
the design prior mean. Defaults to the analysis prior scale}

\item{type}{Type of \eqn{t}-test. Can be \code{"two.sample"} (default),
\code{"one.sample"}, or \code{"paired"}}

\item{alternative}{Direction of the test. Can be either \code{"two.sided"}
(default), \code{"less"}, or \code{"greater"}. The latter two truncate
the analysis prior to negative and positive effects, respectively. If set
to \code{"less"} or \code{"greater"}, the power is only computed based on
data with effect estimates in the direction of the alternative}

\item{lower.tail}{Logical indicating whether Pr(BF \eqn{\leq} \code{k})
(\code{TRUE}) or Pr(BF \eqn{>} \code{k}) (\code{FALSE}) should be
computed. Defaults to \code{TRUE}}

\item{drange}{Standardized mean difference search range over which the
critical values are searched for. Can be either set to a numerical range
or to \code{"adaptive"} (default) which determines the range in an
adaptive way from the other input parameters}

\item{...}{Other arguments passed to \code{stats::uniroot}}
}
\value{
The probability that the Bayes factor is less or greater (depending
    on the specified \code{lower.tail}) than the specified threshold \code{k}
}
\description{
This function computes the probability of obtaining a
    \eqn{t}-test Bayes factor (\link{tbf01}) more extreme than a threshold
    \code{k} with a specified sample size.
}
\examples{
## example from Schönbrodt and Wagenmakers (2018, p. 135)
ptbf01(k = 1/6, n = 146, dpm = 0.5, dpsd = 0, alternative = "greater")
ptbf01(k = 6, n = 146, dpm = 0, dpsd = 0, alternative = "greater",
       lower.tail = FALSE)

## two-sided
ptbf01(k = 1/6, n = 146, dpm = 0.5, dpsd = 0)
ptbf01(k = 6, n = 146, dpm = 0, dpsd = 0, lower.tail = FALSE)

## one-sample test
ptbf01(k = 1/6, n = 146, dpm = 0.5, dpsd = 0, alternative = "greater", type = "one.sample")

}
\seealso{
\link{tbf01}, \link{ntbf01}, \link{powertbf01}
}
\author{
Samuel Pawel
}
