% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc.R
\name{RunMCMC}
\alias{RunMCMC}
\title{Run MCMC}
\usage{
RunMCMC(jags.model, params = NULL, name.list, data.list,
  initial.list = list(), run.contrasts = FALSE,
  use.contrast = "between", contrasts = NULL, custom.contrast = NULL,
  run.ppp = FALSE, k.ppp = 10, n.data, credible.region = 0.95,
  save.data = FALSE, ROPE = NULL, merge.MCMC = FALSE,
  run.diag = FALSE, param.diag = NULL, sep = ",",
  monochrome = TRUE, plot.colors = c("#495054", "#e3e8ea"),
  graphic.type = "pdf", plot.size = "15,10", scaling = 100,
  plot.aspect = NULL, vector.graphic = FALSE, point.size = 12,
  font.type = "serif", one.file = TRUE, ppi = 300, units = "in",
  layout = "a4", layout.inverse = FALSE, ...)
}
\arguments{
\item{jags.model}{specify which module to use}

\item{params}{define parameters to observe, Default: NULL}

\item{name.list}{list of names}

\item{data.list}{list of data}

\item{initial.list}{initial values for analysis, Default: list()}

\item{run.contrasts}{logical, indicating whether or not to run contrasts, Default: FALSE}

\item{use.contrast}{choose from "between", "within" and "mixed". Between compare groups at different conditions. Within compare a group at different conditions. Mixed compute all comparisons, Default: "between",}

\item{contrasts}{define contrasts to use for analysis (defaults to all) , Default: NULL}

\item{custom.contrast}{define contrasts for custom models , Default: NULL}

\item{run.ppp}{logical, indicating whether or not to conduct ppp analysis, Default: FALSE}

\item{k.ppp}{run ppp for every kth length of MCMC chains, Default: 10}

\item{n.data}{sample size for each parameter}

\item{credible.region}{summarize uncertainty by defining a region of most credible values (e.g., 95 percent of the distribution), Default: 0.95}

\item{save.data}{logical, indicating whether or not to save data, Default: FALSE}

\item{ROPE}{define range for region of practical equivalence (e.g., c(-0.05 , 0.05), Default: NULL}

\item{merge.MCMC}{logical, indicating whether or not to merge MCMC chains, Default: FALSE}

\item{run.diag}{logical, indicating whether or not to run diagnostics, Default: FALSE}

\item{param.diag}{define parameters to use for diagnostics, default equals all parameters, Default: NULL}

\item{sep}{symbol to separate data (e.g., comma-delimited), Default: ','}

\item{monochrome}{logical, indicating whether or not to use monochrome colors, else use \link[bfw]{DistinctColors}, Default: TRUE}

\item{plot.colors}{range of color to use, Default: c("#495054", "#e3e8ea")}

\item{graphic.type}{type of graphics to use (e.g., pdf, png, ps), Default: 'pdf'}

\item{plot.size}{size of plot, Default: '15,10'}

\item{scaling}{scale size of plot, Default: 100}

\item{plot.aspect}{aspect of plot, Default: NULL}

\item{vector.graphic}{logical, indicating whether or not visualizations should be vector or raster graphics, Default: FALSE}

\item{point.size}{point size used for visualizations, Default: 12}

\item{font.type}{font type used for visualizations, Default: 'serif'}

\item{one.file}{logical, indicating whether or not visualizations should be placed in one or several files, Default: TRUE}

\item{ppi}{define pixel per inch used for visualizations, Default: 300}

\item{units}{define unit of length used for visualizations, Default: 'in'}

\item{layout}{define a layout size for visualizations, Default: 'a4'}

\item{layout.inverse}{logical, indicating whether or not to inverse layout (e.g., landscape) , Default: FALSE}

\item{...}{further arguments passed to or from other methods}
}
\value{
list containing MCMC chains , MCMC chains as matrix , summary of MCMC, list of name used, list of data, the jags model, running time of analysis and names of saved files
}
\description{
Conduct MCMC simulations using JAGS
}
\seealso{
\code{\link[runjags]{runjags.options}},\code{\link[runjags]{run.jags}}
 \code{\link[parallel]{detectCores}}
 \code{\link[coda]{as.mcmc.list}},\code{\link[coda]{varnames}}
 \code{\link[plyr]{rbind.fill}}
 \code{\link[stats]{cor}},\code{\link[stats]{cov}},\code{\link[stats]{sd}}
 \code{\link[MASS]{mvrnorm}}
 \code{\link[utils]{write.table}}
}
