% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InteractionTest.R
\name{diagnosticPlot2}
\alias{diagnosticPlot2}
\title{Diagnostics F Statistiics Visualization}
\usage{
diagnosticPlot2(diagnosticTest, number = 1, StatVal = TRUE,
  binwidth = NULL)
}
\arguments{
\item{diagnosticTest}{output of \code{\link{diagnosticTest}} with \code{save_F=TRUE} which contains the F-statistics and sampling replicates.}

\item{number}{Number of which BC to plot. This needs to be one of the Biclusters requested in in \code{\link{diagnosticTest}}.}

\item{StatVal}{Boolean value to draw the observed statistic on the distribution plots.}

\item{binwidth}{The width of the bins.}
}
\value{
Returns a \code{ggplot} object.
}
\description{
Plots distributions of bootstrap replicates of F-statistics for row, column and multiplicative effects obtained from \code{\link{diagnosticTest}} (when \code{save_F=TRUE}). 
Contains an option to highlight the observed statistics.
}
\examples{

\dontshow{
test <- matrix(rnorm(5000),100,50)
roweff <- sample(1:5,10,replace=TRUE)
coleff <- sample(1:5,10,replace=TRUE)
test[11:20,11:20] <- test[11:20,11:20] +
  matrix(coleff,nrow=10,ncol=10,byrow=TRUE) +
  matrix(roweff,nrow=10,ncol=10) +
  roweff \%*\% t(coleff)


#Apply Plaid Biclustering
res <- biclust(test, method=BCPlaid())

#Apply default diagnosticTest
out <- diagnosticTest(BCresult=res, data=test, save_F=TRUE, number=1,
                      statistics=c("F"),
                      samplingtypes=c("Permutation"))
diagnosticPlot2(out,number=1)
}

\dontrun{
#Random matrix with embedded bicluster (with multiplicative effect)
test <- matrix(rnorm(5000),100,50)
roweff <- sample(1:5,10,replace=TRUE)
coleff <- sample(1:5,10,replace=TRUE)
test[11:20,11:20] <- test[11:20,11:20] +
  matrix(coleff,nrow=10,ncol=10,byrow=TRUE) +
  matrix(roweff,nrow=10,ncol=10) +
  roweff \%*\% t(coleff)


#Apply Plaid Biclustering
res <- biclust(test, method=BCPlaid())

#Apply default diagnosticTest
out <- diagnosticTest(BCresult=res, data=test, save_F=TRUE, number=1,
                      statistics=c("F","Tukey","ModTukey","Tusell","Mandel","LBI","JandG"),
                      samplingtypes=c("Permutation","SemiparPerm","SemiparBoot",
                      "PermutationCor","SamplingCor","NormSim"))

#Plot Distributions
diagnosticPlot2(out,number=1)
}

}
\author{
Ewoud De Troyer
}
