% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{sim}
\alias{sim}
\title{Simulation of Open, High, Low, and Close Prices}
\usage{
sim(
  n = 10000,
  trades = 390,
  prob = 1,
  spread = 0.01,
  volatility = 0.03,
  overnight = 0,
  drift = 0,
  units = "day",
  sign = FALSE
)
}
\arguments{
\item{n}{the number of periods to simulate.}

\item{trades}{the number of trades per period.}

\item{prob}{the probability to observe a trade.}

\item{spread}{the bid-ask spread.}

\item{volatility}{the open-to-close volatility.}

\item{overnight}{the close-to-open volatility.}

\item{drift}{the expected return per period.}

\item{units}{the units of the time period. One of: \code{sec}, \code{min}, \code{hour}, \code{day}, \code{week}, \code{month}, \code{year}.}

\item{sign}{whether to return positive prices for buys and negative prices for sells.}
}
\value{
Simulated open, high, low, and close prices.
}
\description{
This function performs simulations consisting of \code{n} periods (e.g., days) and where each period consists of a given number of \code{trades}.
For each trade, the actual price \eqn{P_t} is simulated as \eqn{P_t = P_{t-1}e^{\sigma x}}, where \eqn{\sigma} is the standard deviation per trade and \eqn{x} is a random draw from a unit normal distribution.
The standard deviation per trade equals the \code{volatility} divided by the square root of the number of \code{trades}.
Trades are assumed to be observed with a given \code{probability}.
The bid (ask) for each trade is defined as \eqn{P_t} multiplied by one minus (plus) half the \code{spread} and we assume a 50\% chance that a bid (ask) is observed.
High and low prices equal the highest and lowest prices observed during the period.
Open and Close prices equal the first and the last price observed in the period.
If no trade is observed for a period, then the previous Close is used as the Open, High, Low, and Close prices for that period.
}
\note{
Please cite Ardia, Guidotti, & Kroencke (2024) 
when using this package in publication.
}
\references{
Ardia, D., Guidotti, E., Kroencke, T.A. (2024). Efficient Estimation of Bid-Ask Spreads from Open, High, Low, and Close Prices. Journal of Financial Economics, 161, 103916. 
\doi{10.1016/j.jfineco.2024.103916}
}
