% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoSVD.R
\name{snp_autoSVD}
\alias{snp_autoSVD}
\title{Truncated SVD with pruning}
\usage{
snp_autoSVD(G, infos.chr, infos.pos, ind.row = rows_along(G),
  ind.col = cols_along(G), fun.scaling = snp_scaleBinom(), thr.r2 = 0.2,
  size = 500, k = 10, roll.size = 50, int.min.size = 20, ncores = 1,
  verbose = TRUE)
}
\arguments{
\item{G}{A \link[=FBM.code256-class]{FBM.code256}
(typically \code{<bigSNP>$genotypes}).\cr
\strong{You shouldn't have missing values in your data or SNPs with 0 MAF.}}

\item{infos.chr}{Vector of integers specifying each SNP's chromosome.\cr
Typically \code{<bigSNP>$map$chromosome}.}

\item{infos.pos}{Vector of integers specifying the physical position
on a chromosome (in base pairs) of each SNP.\cr
Typically \code{<bigSNP>$map$physical.pos}.}

\item{ind.row}{An optional vector of the row indices (individuals) that
are used. If not specified, all rows are used.\cr
\strong{Don't use negative indices.}}

\item{ind.col}{An optional vector of the column indices (SNPs) that are used.
If not specified, all columns are used.\cr
\strong{Don't use negative indices.}}

\item{fun.scaling}{A function that returns a named list of
\code{mean} and \code{sd} for every column, to scale each of their elements
such as followed: \deqn{\frac{X_{i,j} - mean_j}{sd_j}.}
Default is \code{snp_scaleBinom()}.}

\item{thr.r2}{Threshold on squared correlation between SNPs.
Default is \code{0.2}.}

\item{size}{Radius of the window's size for the LD evaluations of the initial
step of clumping. Default is \code{500}.}

\item{k}{Number of singular vectors/values to compute.
Default is \code{10}. \strong{This algorithm should be used to compute only
a few singular vectors/values.}}

\item{roll.size}{Radius of rolling windows to smooth log-p-values.
Default is \code{50.}}

\item{int.min.size}{Minimum size of intervals of consecutive significant
indices to be reported as long-range LD region. Default is \code{20}.}

\item{ncores}{Number of cores used. Default doesn't use parallelism.
You may use \link{nb_cores}.}

\item{verbose}{Output some information on the iterations? Default is \code{TRUE}.}
}
\value{
A named list (an S3 class "big_SVD") of
\itemize{
\item \code{d}, the singular values,
\item \code{u}, the left singular vectors,
\item \code{v}, the right singular vectors,
\item \code{niter}, the number of the iteration of the algorithm,
\item \code{nops}, number of Matrix-Vector multiplications used,
\item \code{center}, the centering vector,
\item \code{scale}, the scaling vector.
}

Note that to obtain the Principal Components, you must use
\link[=predict.big_SVD]{predict} on the result. See examples.
}
\description{
Fast truncated SVD which iteratively try to remove long-range LD regions
which appear in loadings of SVD.
}
\details{
Improvements will come in the future, as for example, warm starts in order
to make the SVD computations faster.
}
\examples{
ex <- snp_attachExtdata()

obj.svd <- snp_autoSVD(G = ex$genotypes,
                       infos.chr = ex$map$chromosome,
                       infos.pos = ex$map$physical.position)

str(obj.svd)

}
