% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAX3.R
\name{snp_MAX3}
\alias{snp_MAX3}
\title{MAX3 statistic}
\usage{
snp_MAX3(Gna, y01.train, ind.train = rows_along(Gna), val = c(0, 0.5, 1))
}
\arguments{
\item{Gna}{A \link[=FBM.code256-class]{FBM.code256}
(typically \verb{<bigSNP>$genotypes}).\cr
You can have missing values in these data.}

\item{y01.train}{Vector of responses, corresponding to \code{ind.train}.
\strong{Must be only 0s and 1s.}}

\item{ind.train}{An optional vector of the row indices that are used,
for the training part. If not specified, all rows are used.
\strong{Don't use negative indices.}}

\item{val}{Computing \eqn{\smash{\displaystyle\max_{x \in val}}~Z_{CATT}^2(x)}.
\itemize{
\item Default is \code{c(0, 0.5, 1)} and corresponds to the \emph{MAX3} statistic.
\item Only \code{c(0, 1)} corresponds to \emph{MAX2}.
\item And only \code{0.5} corresponds to the Armitage trend test.
\item Finally, \code{seq(0, 1, length.out = L)} corresponds to \emph{MAXL}.
}}
}
\value{
An object of classes \code{mhtest} and \code{data.frame} returning one
score by SNP. See \code{methods(class = "mhtest")}.
}
\description{
Compute the MAX3 statistic, which tests for three genetic models
(additive, recessive and dominant).
}
\details{
\strong{P-values associated with returned scores are in fact the minimum of the
p-values of each test separately. Thus, they are biased downward.}
}
\examples{
set.seed(1)

# constructing a fake genotype big.matrix
N <- 50; M <- 1200
fake <- snp_fake(N, M)
G <- fake$genotypes
G[] <- sample(as.raw(0:3), size = length(G), replace = TRUE)
G[1:8, 1:10]

# Specify case/control phenotypes
fake$fam$affection <- rep(1:2, each = N / 2)

# Get MAX3 statistics
y01 <- fake$fam$affection - 1
str(test <- snp_MAX3(fake$genotypes, y01.train = y01))
# p-values are not well calibrated
snp_qq(test)
# genomic control is not of much help
snp_qq(snp_gc(test))

# Armitage trend test (well calibrated because only one test)
test2 <- snp_MAX3(fake$genotypes, y01.train = y01, val = 0.5)
snp_qq(test2)

}
\references{
Zheng, G., Yang, Y., Zhu, X., & Elston, R. (2012).
Robust Procedures. Analysis Of Genetic Association Studies, 151-206.
\doi{10.1007/978-1-4614-2245-7_6}.
}
