% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcadapt.R
\name{snp_pcadapt}
\alias{snp_pcadapt}
\alias{bed_pcadapt}
\title{Outlier detection}
\usage{
snp_pcadapt(
  G,
  U.row,
  ind.row = rows_along(G),
  ind.col = cols_along(G),
  ncores = 1
)

bed_pcadapt(
  obj.bed,
  U.row,
  ind.row = rows_along(obj.bed),
  ind.col = cols_along(obj.bed),
  ncores = 1
)
}
\arguments{
\item{G}{A \link[=FBM.code256-class]{FBM.code256}
(typically \verb{<bigSNP>$genotypes}).\cr
\strong{You shouldn't have missing values.} Also, remember to do quality control,
e.g. some algorithms in this package won't work if you use SNPs with 0 MAF.}

\item{U.row}{Left singular vectors (not scores, \eqn{U^T U = I})
corresponding to \code{ind.row}.}

\item{ind.row}{An optional vector of the row indices (individuals) that
are used. If not specified, all rows are used.\cr
\strong{Don't use negative indices.}}

\item{ind.col}{An optional vector of the column indices (SNPs) that are used.
If not specified, all columns are used.\cr
\strong{Don't use negative indices.}}

\item{ncores}{Number of cores used. Default doesn't use parallelism.
You may use \link{nb_cores}.}

\item{obj.bed}{Object of type \code{bed}, which is the mapping of some bed file.
Use \code{obj.bed <- bed(bedfile)} to get this object.}
}
\value{
An object of classes \code{mhtest} and \code{data.frame} returning one
score by SNP. See \code{methods(class = "mhtest")}.
}
\description{
Method to detect genetic markers involved in biological adaptation.
This provides a statistical tool for outlier detection based on
Principal Component Analysis. This corresponds to the statistic based
on mahalanobis distance, as implemented in package \strong{pcadapt}.
}
\examples{
test <- snp_attachExtdata()
G <- test$genotypes
obj.svd <- big_SVD(G, fun.scaling = snp_scaleBinom(), k = 10)
plot(obj.svd) # there seems to be 3 "significant" components
pcadapt <- snp_pcadapt(G, obj.svd$u[, 1:3])
snp_qq(snp_gc(pcadapt))

}
\references{
Luu, K., Bazin, E., & Blum, M. G. (2017).
pcadapt: an R package to perform genome scans for selection
based on principal component analysis.
Molecular ecology resources, 17(1), 67-77.
}
\seealso{
\link{snp_manhattan}, \link{snp_qq} and \link{snp_gc}.
}
