% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bb_helpers.R
\name{bb_lollipop}
\alias{bb_lollipop}
\title{Helper for creating a lollipop chart}
\usage{
bb_lollipop(
  bb,
  data,
  mapping = NULL,
  rotated = FALSE,
  point_color = "#112446",
  point_size = 8,
  line_color = "#000",
  ...
)
}
\arguments{
\item{bb}{A \code{billboard} \code{htmlwidget} object.}

\item{data}{A \code{data.frame}, the first column will be used for x axis unless
argument \code{x} is specified, the second one will be use as y values.
 If not a \code{data.frame}, an object coercible to \code{data.frame}.}

\item{mapping}{Mapping of variables on the chart, see \code{\link{bbaes}}.}

\item{rotated}{Switch x and y axis position.}

\item{point_color}{Color of the lollipop.}

\item{point_size}{Size of the lollipop.}

\item{line_color}{Color of the lines between the axis and the lollipop.}

\item{...}{Not used.}
}
\value{
A \code{billboard} \code{htmlwidget} object.
}
\description{
Helper for creating a lollipop chart
}
\examples{

# From wikipedia
sw <- data.frame(
  film = c("The Force Awakens", "The Phantom Menace", 
           "Revenge of the Sith", "A New Hope",
           "Attack of the Clones", "The Empire Strikes Back",
           "Return of the Jedi"
  ),
  worldwide_gross = c(2068178225, 1027044677, 848754768,
                      775398007, 649398328, 538375067,
                      475106177)
)

# Simple example
billboarder() \%>\% 
  bb_lollipop(data = sw)

# Fancy example
billboarder() \%>\% 
  bb_lollipop(data = sw, rotated = TRUE)\%>\% 
  bb_y_grid(show = TRUE) \%>\% 
  bb_y_axis(tick = list(
    values = c(0, 5e+08, 1e+09, 1.5e+09, 2e+09),
    outer = FALSE,
    format = htmlwidgets::JS("d3.formatPrefix('$,.0', 1e6)")
  )) \%>\% 
  bb_x_axis(tick = list(centered = TRUE)) \%>\% 
  bb_labs(
    title = "Star Wars - Total Lifetime Grosses",
    caption = "Data source : wikipedia"
  )


# With mapping
billboarder(data = sw) \%>\% 
  bb_lollipop(mapping = bbaes(x = film, y = worldwide_gross))
  
}
