% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NI.D3.R
\name{NI.D3}
\alias{NI.D3}
\title{Find the optimal testing configuration for non-informative 
three-stage hierarchical testing}
\usage{
NI.D3(p, Se, Sp, group.sz, obj.fn, weights = NULL)
}
\arguments{
\item{p}{the probability of disease, which can be specified as an overall
probability of disease or a homogeneous vector of individual probabilities.}

\item{Se}{the sensitivity of the diagnostic test.}

\item{Sp}{the specificity of the diagnostic test.}

\item{group.sz}{a single group size over which to find the OTC
out of all possible testing configurations, or a range of
group sizes over which to find the OTC.}

\item{obj.fn}{a list of objective functions which are minimized to find the
OTC. The expected number of tests per individual, "\kbd{ET}", will always 
be calculated. Additional options include "\kbd{MAR}" 
(the expected number of tests divided by the expected number of correct 
classifications, described in Malinovsky et al. (2016)), and "\kbd{GR}" 
(a linear combination of the expected number of tests, the number of 
misclassified negatives, and the number of misclassified positives, 
described in Graff & Roeloffs (1972)). See Hitt et al. (2018) at
\url{http://chrisbilder.com/grouptesting} for additional details.}

\item{weights}{a matrix of up to six sets of weights for the GR function. 
Each set of weights is specified by a row of the matrix.}
}
\value{
A list containing:
\item{prob}{the probability of disease, as specified by the user.}
\item{Se}{the sensitivity of the diagnostic test.}
\item{Sp}{the specificity of the diagnostic test.}
\item{opt.ET, opt.MAR, opt.GR}{a list for each objective function specified 
by the user, containing:
\describe{
\item{OTC}{a list specifying elements of the optimal testing configuration, 
which include:
\describe{
\item{Stage1}{pool size for the first stage of testing, i.e. the initial
group size.}
\item{Stage2}{pool sizes for the second stage of testing.}}}
\item{p.vec}{the vector of individual probabilities}
\item{ET}{the expected testing expenditure for the OTC.}
\item{value}{the value of the objective function per individual.}
\item{PSe}{the overall pooling sensitivity for the algorithm. Further 
details are given under 'Details'.}
\item{PSp}{the overall pooling specificity for the algorithm. Further 
details are given under 'Details'.}
\item{PPPV}{the overall pooling positive predictive value for the algorithm. 
Further details are given under 'Details'.}
\item{PNPV}{the overall pooling negative predictive value for the algorithm. 
Further details are given under 'Details'.}}}
}
\description{
Find the optimal testing configuration (OTC) for
non-informative three-stage hierarchical testing and calculate
the associated operating characteristics.
}
\details{
This function finds the OTC and computes the associated operating 
characteristics for non-informative three-stage hierarchical testing, 
by considering all possible testing configurations. 
Operating characteristics calculated are expected number of tests, pooling 
sensitivity, pooling specificity, pooling positive predictive value, and 
pooling negative predictive value for the algorithm. See Hitt et al. (2018) at
\url{http://chrisbilder.com/grouptesting} or Kim et al. (2007) 
for additional details on the implementation of non-informative three-stage 
hierarchical testing.

The value(s) specified by \kbd{group.sz} represent the initial (stage 1) 
group size. If a single value is provided for \kbd{group.sz}, the OTC 
will be found over all possible testing configurations for that initial 
group size. If a range of group sizes is specified, the OTC will be found 
over all group sizes.

The displayed pooling sensitivity, pooling specificity, pooling positive 
predictive value, and pooling negative predictive value are weighted 
averages of the corresponding individual accuracy measures for all 
individuals within the initial group for a hierarchical algorithm.
Expressions for these averages are provided in the Supplementary 
Material for Hitt et al. (2018). These expressions are based on accuracy 
definitions given by Altman and Bland (1994a, 1994b).
}
\examples{
# Find the OTC for non-informative three-stage 
#   hierarchical testing over a range of group sizes.
# This example takes approximately 20 seconds to run.
# Estimated running time was calculated using a 
#   computer with 16 GB of RAM and one core of an 
#   Intel i7-6500U processor.
\dontrun{
NI.D3(p=0.02, Se=0.90, Sp=0.90, group.sz=3:30, 
obj.fn=c("ET", "MAR"))}

# This example takes less than 1 second to run.
# Estimated running time was calculated using a 
#   computer with 16 GB of RAM and one core of an 
#   Intel i7-6500U processor.
NI.D3(p=0.02, Se=0.90, Sp=0.90, group.sz=3:12, 
obj.fn=c("ET", "MAR"))

# Find the OTC out of all possible configurations for 
#   a specified group size for non-informative
#   three-stage hierarchical testing.
# This example takes less than 1 second to run.
# Estimated running time was calculated using a 
#   computer with 16 GB of RAM and one core of an 
#   Intel i7-6500U processor.
NI.D3(p=rep(0.005, 15), Se=0.99, Sp=0.99, group.sz=15,
obj.fn=c("ET", "MAR", "GR"), weights=matrix(data=c(1,1,10,10), 
nrow=2, ncol=2, byrow=TRUE))
}
\references{
\insertRef{Altman1994a}{binGroup}

\insertRef{Altman1994b}{binGroup}

\insertRef{Graff1972}{binGroup}

\insertRef{Hitt2018}{binGroup}

\insertRef{Kim2007}{binGroup}

\insertRef{Malinovsky2016}{binGroup}
}
\seealso{
\code{\link{Inf.D3}} for informative three-stage hierarchical testing, 
\code{\link{NI.Dorf}} for non-informative two-stage hierarchical (Dorfman) 
testing, \code{\link{Inf.Dorf}} for informative two-stage hierarchical 
testing, and \code{\link{OTC}} for finding the optimal testing configuration 
for a number of standard group testing algorithms.

\url{http://chrisbilder.com/grouptesting}

Other OTC functions: \code{\link{Inf.Array}},
  \code{\link{Inf.D3}}, \code{\link{Inf.Dorf}},
  \code{\link{NI.A2M}}, \code{\link{NI.Array}},
  \code{\link{NI.Dorf}}, \code{\link{OTC}}
}
\author{
Brianna D. Hitt
}
