% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/halving.R
\name{pmf.halving}
\alias{pmf.halving}
\title{Extract probability mass function (PMF) from group testing results}
\usage{
\method{pmf}{halving}(object, ...)
}
\arguments{
\item{object}{An object of class "halving", created by \code{\link{halving}},
from which the PMF is to be extracted.}

\item{...}{currently not used.}
}
\value{
Data frame containing the probability mass function
extracted from the object \kbd{object}.
}
\description{
Extract the probability mass function from group testing results
for the halving algorithm (objects of class "halving" returned
by \code{\link{halving}}).
}
\examples{
res <- halving(p = rep(0.01, 10), Sp = 1, Se = 1,
               stages = 2, order.p = TRUE)
pmf(res)
}
\author{
Brianna D. Hitt
}
