% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OTCMethodFunctions.R
\name{ExpTests.OTC}
\alias{ExpTests.OTC}
\title{Extract the expected number of tests from optimal testing
configuration results}
\usage{
\method{ExpTests}{OTC}(object, ...)
}
\arguments{
\item{object}{An object of class "OTC", from which the expected number
of tests and expected number of tests per individual are to be extracted.}

\item{...}{Additional arguments to be passed to \code{ExpTests} (e.g.,
\code{digits} to be passed to \code{round} for appropriate rounding).}
}
\value{
A data frame containing the columns:
\item{ExpTests}{the expected number of tests required by the optimal testing
configuration.}
\item{ExpTestsPerInd}{the expected number of tests per individual for the optimal
testing configuration.}
\item{PercentReductionTests}{The percent reduction in the number of tests; 100 * (1 - ExpTestsPerIndividual).}
\item{PercentIncreaseTestCap}{The percent increase in testing capacity when the algorithm
  is applied to a continuous stream of specimens; 100 * (1/ExpTestsPerIndividual - 1).}
Each row of the data frame represents an objective function specified in
the call to \code{\link{OTC1}} or \code{\link{OTC2}}.
}
\description{
Extract the expected number of tests and expected number of
tests per individual from objects of class "OTC" returned by
\code{\link{OTC1}} or \code{\link{OTC2}}.
}
\examples{
res1 <- OTC1(algorithm = "D2", p = 0.05, Se = 0.99, Sp = 0.99,
             group.sz = 2:100, obj.fn = c("ET", "MAR"),
             trace = TRUE)
ExpTests.OTC(res1)
}
\references{
\insertRef{bilder2020tests}{binGroup2}
}
\author{
Brianna D. Hitt and Christopher R. Bilder
}
