% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stackbarPlots.R
\name{stackbarPlots}
\alias{stackbarPlots}
\title{Create stack bar plots showing trajectories sizes and the three change components.}
\usage{
stackbarPlots(
  input,
  axisSize = 12,
  lbAxSize = 15,
  lgSize = 12,
  titleSize = 15,
  datbreaks = "no",
  upperlym = 35,
  lowerlym = -50,
  lymby = 5,
  upperlym2 = 0.5,
  lymby2 = 0.1,
  xAngle = 0
)
}
\arguments{
\item{input}{is the results from running the "dataStack" function.}

\item{axisSize}{is a numerical value that control the size of the labels on tick marks of the horizontal
and vertical tick marks.}

\item{lbAxSize}{is a numerical value to control the size of the labels on the horizontal and vertical axis.}

\item{lgSize}{is a numerical value to control the size of the legend text.}

\item{titleSize}{is a numerical value to control the size of the title text.}

\item{datbreaks}{is a string of "yes" or "no", which controls the range and sub-division of the vertical axis
of the stacked bar plots.The default is "no", which automatically generates the range and interval of the vertical axis.
If "no" the user need to mannual input values for "upperlym","lowerlym", "lymby","upperlym2", and "lymby2".}

\item{upperlym}{if datbreaks set to "yes," is a numerical value to control the upper limit of the trajectory stack bar plot.}

\item{lowerlym}{if datbreaks set to "yes," is a numerical value to control the lower limit of the trajectory stack bar plot.}

\item{lymby}{if datbreaks set to "yes," is a numerical value to control interval on the vertical axis of the components of change stack bar plot.}

\item{upperlym2}{if datbreaks set to "yes," is a numerical value to control the upper limit of the components of change stacked bar plot.}

\item{lymby2}{if datbreaks set to "yes," is a numerical value to control the interval on the vertical axis of the components of change stacked bar plot.}

\item{xAngle}{is a numerical value to control the orientation of the text on the vertical axis of the trajectory stack bar plot}
}
\value{
The output from \code{\link{stackbarPlots}}
}
\description{
Create stack bar plots showing trajectories sizes and the three change components.
}
\examples{
example_data <- terra::rast(system.file("external/Example_raster_Y.tif",package="binaryTimeSeries"))
no_data <- 2
cat_interest <- 1
unified_resp <- "yes"
time_points <- c(2000,2001,2002,2003,2005)
categ_name <- "Category"
region_name <- "Study Region"
datstk_output <- dataStack(x = example_data,nodata = no_data,category = cat_interest,
unified = unified_resp,timePoints = time_points,categoryName = categ_name,
regionName = region_name)
stkbarplt_output <- stackbarPlots(input = datstk_output,axisSize = 12,
lbAxSize = 15,lgSize = 12,titleSize = 15,upperlym = 35,lowerlym = - 50,
lymby = 5,upperlym2 = 0.5,lymby2 = 0.1,xAngle = 0)

}
