% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predl_templates.R
\name{predl_bitbucket_downloads}
\alias{predl_bitbucket_downloads}
\title{Pre download bitbucket downloads}
\usage{
predl_bitbucket_downloads(url, platform, history, appname,
  platformregex = platform, versionregex = "\\\\d+(?:\\\\.\\\\d+)+")
}
\arguments{
\item{url}{A url giving the bitbucket download JSON for a project. As
an example https://bitbucket.org/ariya/phantomjs/downloads the
phantomjs project has an asset JSON available at
https://api.bitbucket.org/2.0/repositories/ariya/phantomjs/downloads?pagelen=100}

\item{platform}{A character vector of platform names}

\item{history}{The maximum number of files to get for a platform}

\item{appname}{Name of the app}

\item{platformregex}{A filter for platforms. Defaults to the platform}

\item{versionregex}{A regex for retrieving the version.}
}
\value{
A named list of data.frames. The name indicates the
    platform. The data.frame should contain the version, url and file
    to be processed. Used as input for \code{\link{download_files}} or
    an equivalent.
}
\description{
Pre download bitbucket downloads template function
}
\examples{
\dontrun{
bbdata <- system.file("testdata", "test_bitbucketdl.json",
                      package="binman")
platform <- c("linux64", "linux32", "windows", "macosx")
platformregex <- c("linux-x86_64", "linux-i686", "windows", "macosx")
bbdllist <-
  predl_bitbucket_downloads(url = bbdata, platform, history = 3L,
                            appname = "binman_chromedriver",
                            platformregex)
}
}

