% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indices_pruebas.R
\name{emergence.indices}
\alias{emergence.indices}
\title{Nonparametric estimates of indices measuring the global slope and curvature of the density function for binned data.}
\usage{
emergence.indices(n, y, w, ni, hseq, hn = 200, nmix = 4, B = 500,
  method = "np", last.iter.np = F, confint = FALSE, B.conf = 1000,
  alpha = 0.05, print = TRUE, parallel = FALSE, pars = new.env())
}
\arguments{
\item{n}{Positive integer. Size of the complete sample.}

\item{y}{Vector. Observed values. They define the extremes of the sequence of intervals in which data is binned.}

\item{w}{Vector. Proportion of observations within each interval.}

\item{ni}{Vector. Number of observations within each interval.}

\item{hseq}{Vector. Grid of bandwidths for which MSE is approximated through bootstrap. If missing, a grid of size hn is considered.}

\item{hn}{Positive integer. Size of the grid of bandwidths for which MSE will be approximated. Defaults to 200.}

\item{nmix}{Positive integer. Maximum number of components for the normal mixture model. Defaults to 4.}

\item{B}{Positive integer. Number of bootstrap resamples used to find the bandwidth that minimizes MSE. Defaults to 500.}

\item{method}{Character. If method="np", resamples are taken from kernel density estimator with pilot bandwidth. If method="mix", a normal mixture pilot model is considered. If method="plugin", plug-in estimates are returned. Defaults to "np".}

\item{last.iter.np}{Logical. If FALSE, normality is assumed at the last step when calculating the plug-in bandwidth. Otherwise, rule-of-thumb selector is used. Defaults to FALSE.}

\item{confint}{Logical. If TRUE, bootstrap confidence intervals are constructed for the indices. Defaults to FALSE.}

\item{B.conf}{Positive integer. Number of bootstrap resamples considered to construct the confidence intervals.}

\item{alpha}{Real number between 0 and 1. Significance level considered for the confidence intervals.}

\item{print}{Logical. If TRUE, status of the script and results are printed. Defaults to TRUE.}

\item{parallel}{Logical. If TRUE, confidence bands are estimated using parallel computing with sockets.}

\item{pars}{Environment. Needed for the well functioning of the script. DO NOT modify this argument.}
}
\value{
Nonparametric estimates of the indices and (optional) confidence intervals.
}
\description{
Nonparametric estimates of indices measuring the global slope and curvature of the density function for binned data.
}
\examples{
set.seed(1)
n <- 200 #complete sample size
k <- 30 #number of intervals
x <- rnorm(n,6,1) #complete sample
y <- seq(min(x)-0.2,max(x)+0.2,len=k+1) #intervals
w <- c(sapply(2:k,function(i)sum( x<y[i]&x>=y[i-1] )), sum(x<=y[k+1]&x>=y[k]) )/n #proportions
emergence.indices(n,y,w)

}
\references{
\insertRef{Indices2011}{binnednp}

\insertRef{Test2017}{binnednp}
}
