% Generated by roxygen2 (4.0.1): do not edit by hand
\name{bins.optimize}
\alias{bins.merge}
\alias{bins.merge.iter}
\alias{bins.move}
\alias{bins.move.iter}
\alias{bins.optimize}
\alias{bins.split}
\alias{bins.split.iter}
\title{Algorithms minimizing the binning error function \code{bins.merr}.}
\usage{
bins.move(xval, xtbl, binlo, binhi, binct, target.bins, verbose = F)

bins.split(xval, xtbl, binlo, binhi, binct, target.bins, force = F,
  verbose = F)

bins.merge(xval, xtbl, binlo, binhi, binct, target.bins, force = F,
  verbose = F)

bins.move.iter(lst, target.bins, verbose = F)

bins.split.iter(lst, target.bins, exact.groups = F, verbose = F)

bins.merge.iter(lst, target.bins, exact.groups = F, verbose = F)
}
\arguments{
\item{xval}{Sorted unique values of the data set x. This should be the numeric version of \code{names(xtbl)}.}

\item{xtbl}{Result of a call to \code{table(x)}.}

\item{binlo}{The "low" value falling into the bin.}

\item{binhi}{The "high" value falling into the bin.}

\item{binct}{The number of points falling into the bin.}

\item{target.bins}{Number of bins desired; this is also the max number of bins.}

\item{force}{When \code{TRUE}, splits or merges bins regardless of whether the best gain is positive.}

\item{verbose}{When \code{TRUE}, prints resulting \code{binct}.}

\item{lst}{List containing \code{xval, xtbl, binlo, binhi, binct}.}

\item{exact.groups}{If \code{FALSE}, run until either the target.bins is
reached or there's no more splits or merges that reduce the error.
Otherwise (\code{TRUE}), run until the target.bins is reached, even if that
increases the error.}
}
\value{
A list containing the following items (not all of them may be present):
\itemize{
   \item{binlo}{ - The "low" value falling into the bin.}
   \item{binhi}{ - The "high" value falling into the bin.}
   \item{binct}{ - The number of points falling into the bin.}
   \item{xtbl}{ - The result of a call to \code{table(x)}.}
   \item{xval}{ - The sorted unique values of the data points x. Essentially, a numeric version of \code{names(xtbl)}.}
   \item{changed}{ - Flag indicating whether the bins have been modified by the function.}
   \item{err}{ - Mean square root error between the resulting counts and ideal bins.}
   \item{imax}{ - For the move, merge and split operations, the index of the bin with the maximum gain.}
   \item{iside}{ - For the move operation, the side of the move: 0 = left, 1 = right.}
   \item{gain}{ - Error gain obtained as the result of the function call.}
}
}
\description{
\code{bins.move} - Compute the best move of a value from one bin to its neighbor

\code{bins.split} - Split a bin into two bins optimally.

\code{bins.merge} - Merges the two bins yielding the largest gain in error reduction.

\code{bins.move.iter} - Apply \code{bins.move} until there's no change. Can only reduce the error.

\code{bins.split.iter}  Iterate to repeatedly apply \code{bins.split}.

\code{bins.merge.iter} Iterate to repeatedly apply \code{bins.merge}.
}
\seealso{
\code{\link{bins}}, \code{\link{binr}}, \code{\link{bins.greedy}}, \code{\link{bins.quantiles}}
}

