## ------------------------------------------------------------------------
library(tidyverse)

## ------------------------------------------------------------------------
library(bioOED)

## ------------------------------------------------------------------------
pars <- list(z = 4.2, D_R = 3.9, temp_ref = 55)

## ------------------------------------------------------------------------
design_space <- expand.grid(seq(0, 100, length = 20),
                            seq(52.5,60, length = 20)
                            ) %>%
  set_names("times", "temperature")

head(design_space)

## ------------------------------------------------------------------------
my_sensitivities <- isothermal_sensitivities("Bigelow", design_space, pars)

## ------------------------------------------------------------------------
head(my_sensitivities$sensitivities)

## ---- fig.width=8--------------------------------------------------------
plot(my_sensitivities)

## ---- fig.width=8--------------------------------------------------------
plot(my_sensitivities, limit = 7)

## ------------------------------------------------------------------------
n_points <- 5

## ------------------------------------------------------------------------
# opts <- list(maxeval=500,local_finish="DHC")
# 
# OED <- isothermal_OED("Bigelow", pars, n_points, criterion = "D",
#                       min_time = 0, max_time = 100,
#                       min_temp = 52.5, max_temp = 60,
#                       opts = opts)

## ------------------------------------------------------------------------
# OED$optim_design

## ---- fig.width=8--------------------------------------------------------
# plot(OED)

## ------------------------------------------------------------------------
limit <- 7

## ------------------------------------------------------------------------
# OED_limit <- isothermal_OED_limit("Bigelow", pars, n_points, criterion = "D", limit,
#                                   min_time = 0, max_time = 100, min_temp = 95,
#                                   max_temp = 110, opts)

## ------------------------------------------------------------------------
# print(OED_limit$optim_design)

## ---- fig.width=8--------------------------------------------------------
# plot(OED_limit)

