% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nexrad_odim.R
\name{nexrad_to_odim}
\alias{nexrad_to_odim}
\title{Convert a NEXRAD polar volume file to an ODIM polar volume file}
\usage{
nexrad_to_odim(pvolfile_nexrad, pvolfile_odim, verbose = FALSE)
}
\arguments{
\item{pvolfile_nexrad}{Character (vector). Either a path to a single radar polar volume
(\code{pvol}) file containing multiple scans/sweeps, or multiple paths to scan
files containing a single scan/sweep. Or a single \code{pvol} object. The file data format should be either 1)
\href{https://github.com/adokter/vol2bird/blob/master/doc/OPERA2014_O4_ODIM_H5-v2.2.pdf}{ODIM}
format, which is the implementation of the OPERA data information model in
the \href{https://www.hdfgroup.org/solutions/hdf5/}{HDF5} format, 2) a format
supported by the \href{https://trmm-fc.gsfc.nasa.gov/trmm_gv/software/rsl/}{RSL library} or 3) Vaisala
IRIS (IRIS RAW) format.}

\item{pvolfile_odim}{Filename for the polar volume in ODIM HDF5 format to be
generated.}

\item{verbose}{Logical. When \code{TRUE}, vol2bird \code{stdout} is piped to the R
console.}
}
\value{
\code{TRUE} on success
}
\description{
Convert a NEXRAD polar volume file to an ODIM polar volume file
}
\examples{
\donttest{
# download a NEXRAD file, save as KBGM_example
path = file.path(tempdir(), "KBGM_example")

download.file(paste0("https://noaa-nexrad-level2.s3.amazonaws.com/",
  "2019/10/01/KBGM/KBGM20191001_000542_V06"), path, method="libcurl", mode="wb")

# convert to ODIM format

new_path = file.path(tempdir(), "KBGM_example.h5")

if (requireNamespace("vol2birdR", quietly = TRUE)) {
nexrad_to_odim(path, new_path)

# verify that we have generated a polar volume in ODIM HDF5 format
get_odim_object_type(new_path)

# clean up
file.remove(new_path)
}
file.remove(path)
}
}
