% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_biobal_raster.R
\name{biobalRaster}
\alias{biobalRaster}
\title{Computation of Bioclimatic Balance (raster mode)}
\usage{
biobalRaster(bh, CC, wout = NULL, ncpu = 1)
}
\arguments{
\item{bh}{Water balance in raster format.}

\item{CC}{Field capacity. It depends on water retention capacity and depth of roots. 400 as default value. It can be a SpatRaster layer.}

\item{wout}{Name of the raster output file.}

\item{ncpu}{Number of CPUs to use. By default, sequential mode (1 cpu) is used.}
}
\value{
SpatRaster with 48 layers corresponding to the 12 monthly values of 'B', 'b','bc','bl'.
}
\description{
Computes bioclimatic balance from water balance in raster format.
}
\examples{
\donttest{
wb <- terra::rast(wbRast)
bb <- biobalRaster(wb, CC = 400, wout=NULL, ncpu = 2)
}
}
