% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export-docs.R
\name{export_html}
\alias{export_html}
\title{Export BioCompute Object as HTML}
\usage{
export_html(x, file, wrap = FALSE, linewidth = 80, ...)
}
\arguments{
\item{x}{BioCompute Object JSON string from \code{\link{convert_json}}}

\item{file}{HTML output file path}

\item{wrap}{Should the long lines be wrapped?}

\item{linewidth}{Maximum linewidth when \code{wrap} is \code{TRUE}.}

\item{...}{Additional parameters for \code{\link[rmarkdown]{render}}.}
}
\value{
Path to the output file
}
\description{
Export BioCompute Object as HTML
}
\examples{
\donttest{
file_html <- tempfile(fileext = ".html")
generate_example("HCV1a") \%>\%
  convert_json() \%>\%
  export_html(file_html)
}
}
