% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GlobalGrowthFit_class.R, R/predictMCMC.R
\name{GlobalGrowthFit}
\alias{GlobalGrowthFit}
\alias{print.GlobalGrowthFit}
\alias{coef.GlobalGrowthFit}
\alias{summary.GlobalGrowthFit}
\alias{predict.GlobalGrowthFit}
\alias{residuals.GlobalGrowthFit}
\alias{vcov.GlobalGrowthFit}
\alias{deviance.GlobalGrowthFit}
\alias{fitted.GlobalGrowthFit}
\alias{logLik.GlobalGrowthFit}
\alias{AIC.GlobalGrowthFit}
\alias{plot.GlobalGrowthFit}
\alias{predictMCMC.GlobalGrowthFit}
\title{GlobalGrowthFit class}
\usage{
\method{print}{GlobalGrowthFit}(x, ...)

\method{coef}{GlobalGrowthFit}(object, ...)

\method{summary}{GlobalGrowthFit}(object, ...)

\method{predict}{GlobalGrowthFit}(object, env_conditions, times = NULL, ...)

\method{residuals}{GlobalGrowthFit}(object, ...)

\method{vcov}{GlobalGrowthFit}(object, ...)

\method{deviance}{GlobalGrowthFit}(object, ...)

\method{fitted}{GlobalGrowthFit}(object, ...)

\method{logLik}{GlobalGrowthFit}(object, ...)

\method{AIC}{GlobalGrowthFit}(object, ..., k = 2)

\method{plot}{GlobalGrowthFit}(
  x,
  y = NULL,
  ...,
  add_factor = NULL,
  ylims = NULL,
  label_x = "time",
  label_y1 = NULL,
  label_y2 = add_factor,
  line_col = "black",
  line_size = 1,
  line_type = "solid",
  line_col2 = "black",
  line_size2 = 1,
  line_type2 = "dashed",
  point_size = 3,
  point_shape = 16,
  subplot_labels = "AUTO"
)

\method{predictMCMC}{GlobalGrowthFit}(
  model,
  times,
  env_conditions,
  niter,
  newpars = NULL,
  formula = . ~ time
)
}
\arguments{
\item{x}{an instance of GlobalGrowthFit}

\item{...}{ignored}

\item{object}{an instance of \link{GlobalGrowthFit}}

\item{env_conditions}{Tibble with the (dynamic) environmental conditions
during the experiment. It must have one column named 'time' with the
storage time and as many columns as required with the environmental conditions.}

\item{times}{Numeric vector of storage times for the predictions.}

\item{k}{penalty for the parameters (k=2 by default)}

\item{y}{ignored}

\item{add_factor}{whether to plot also one environmental factor.
If \code{NULL} (default), no environmental factor is plotted. If set
to one character string that matches one entry of x$env_conditions,
that condition is plotted in the secondary axis}

\item{ylims}{A two dimensional vector with the limits of the primary y-axis.}

\item{label_x}{label of the x-axis}

\item{label_y1}{Label of the primary y-axis.}

\item{label_y2}{Label of the secondary y-axis.}

\item{line_col}{Aesthetic parameter to change the colour of the line geom in the plot, see: \code{\link[=geom_line]{geom_line()}}}

\item{line_size}{Aesthetic parameter to change the thickness of the line geom in the plot, see: \code{\link[=geom_line]{geom_line()}}}

\item{line_type}{Aesthetic parameter to change the type of the line geom in the plot, takes numbers (1-6) or strings ("solid") see: \code{\link[=geom_line]{geom_line()}}}

\item{line_col2}{Same as lin_col, but for the environmental factor.}

\item{line_size2}{Same as line_size, but for the environmental factor.}

\item{line_type2}{Same as lin_type, but for the environmental factor.}

\item{point_size}{Size of the data points}

\item{point_shape}{shape of the data points}

\item{subplot_labels}{labels of the subplots according to \code{plot_grid}.}

\item{model}{An instance of \link{GlobalGrowthFit}}

\item{niter}{Number of iterations.}

\item{newpars}{A named list defining new values for the some model parameters.
The name must be the identifier of a model already included in the model.
These parameters do not include variation, so defining a new value for a fitted
parameters "fixes" it. \code{NULL} by default (no new parameters).}

\item{formula}{A formula stating the column named defining the elapsed time in
\code{env_conditions}. By default, . ~ time.}
}
\value{
An instance of \link{MCMCgrowth}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The \code{GlobalGrowthFit} class contains a growth model fitted to data
using a global approach. Its constructor is \code{\link[=fit_growth]{fit_growth()}}.

It is a subclass of list with the items:
\itemize{
\item algorithm: type of algorithm as in \code{\link[=fit_growth]{fit_growth()}}
\item data: data used for model fitting
\item start: initial guess of the model parameters
\item known: fixed model parameters
\item primary_model: a character describing the primary model
\item fit_results: an instance of modFit or modMCMC with the results of the fit
\item best_prediction: Instance of \link{GrowthPrediction} with the best growth fit
\item sec_models: a named vector with the secondary models assigned for each
environmental factor. \code{NULL} for \code{environment="constant"}
\item env_conditions: a list with the environmental conditions used for model
fitting. \code{NULL} for \code{environment="constant"}
\item niter: number of iterations of the Markov chain. \code{NULL} if \code{algorithm != "MCMC"}
\item logbase_mu: base of the logarithm for the definition of parameter mu
(check the relevant vignette)
\item logbase_logN: base of the logarithm for the definition of the population size
(check the relevant vignette)
\item environment: "dynamic". Always
}
}
\section{Methods (by generic)}{
\itemize{
\item \code{print(GlobalGrowthFit)}: print of the model

\item \code{coef(GlobalGrowthFit)}: vector of fitted model parameters.

\item \code{summary(GlobalGrowthFit)}: statistical summary of the fit.

\item \code{predict(GlobalGrowthFit)}: vector of model predictions

\item \code{residuals(GlobalGrowthFit)}: model residuals. They are returned as a tibble
with 4 columns: time (storage time), logN (observed count),
exp (name of the experiment) and res (residual).

\item \code{vcov(GlobalGrowthFit)}: variance-covariance matrix of the model, estimated
as 1/(0.5*Hessian) for regression and as the variance-covariance of the draws
for MCMC

\item \code{deviance(GlobalGrowthFit)}: deviance of the model.

\item \code{fitted(GlobalGrowthFit)}: fitted values. They are returned as a
tibble with 3 columns: time (storage time), exp (experiment
identifier) and fitted (fitted value).

\item \code{logLik(GlobalGrowthFit)}: loglikelihood of the model

\item \code{AIC(GlobalGrowthFit)}: Akaike Information Criterion

\item \code{plot(GlobalGrowthFit)}: comparison between the fitted model and
the experimental data.

\item \code{predictMCMC(GlobalGrowthFit)}: prediction including parameter uncertainty

}}
