% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biomod2_classes_3.R
\docType{class}
\name{BIOMOD.projection.out}
\alias{BIOMOD.projection.out}
\alias{BIOMOD.projection.out-class}
\alias{plot,BIOMOD.projection.out,missing-method}
\alias{show,BIOMOD.projection.out-method}
\title{\code{BIOMOD_Projection()} output object class}
\usage{
\S4method{plot}{BIOMOD.projection.out,missing}(x, col = NULL, str.grep = NULL)

\S4method{show}{BIOMOD.projection.out}(object)
}
\arguments{
\item{x}{a \code{\link{BIOMOD.projection.out}} object}

\item{col}{a \code{vector} containing colors for plot (default : 
\code{colorRampPalette(c("grey90", "yellow4", "green4"))(100)})}

\item{str.grep}{a \code{character} corresponding to the name (or part of the name(s)) of 
models projected}

\item{object}{a \code{\link{BIOMOD.projection.out}} object}
}
\description{
Class returned by \code{\link{BIOMOD_Projection}}, and used by 
\code{\link{BIOMOD_EnsembleForecasting}}
}
\section{Slots}{

\describe{
\item{\code{modeling.id}}{a \code{character} corresponding to the name (ID) of the simulation set}

\item{\code{proj.name}}{a \code{character} corresponding to the projection name}

\item{\code{dir.name}}{a \code{character} corresponding to the modeling folder}

\item{\code{sp.name}}{a \code{character} corresponding to the species name}

\item{\code{expl.var.names}}{a \code{vector} containing names of explanatory variables}

\item{\code{coord}}{a 2-columns \code{matrix} or \code{data.frame} containing the corresponding 
\code{X} and \code{Y} coordinates used to project the species distribution model(s)}

\item{\code{scale.models}}{a \code{logical} value defining whether models have been rescaled or 
not}

\item{\code{models.projected}}{a \code{vector} containing names of projected models}

\item{\code{models.out}}{a \code{\link{BIOMOD.stored.data}} object}

\item{\code{type}}{a \code{character} corresponding to the class of the \code{val} slot of the 
\code{proj.out} slot}

\item{\code{proj.out}}{a \code{\link{BIOMOD.stored.data}} object}
}}

\examples{

showClass("BIOMOD.projection.out")

## ----------------------------------------------------------------------- #

# Load species occurrences (6 species available)
myFile <- system.file('external/species/mammals_table.csv', package = 'biomod2')
DataSpecies <- read.csv(myFile, row.names = 1)
head(DataSpecies)

# Select the name of the studied species
myRespName <- 'GuloGulo'

# Get corresponding presence/absence data
myResp <- as.numeric(DataSpecies[, myRespName])

# Get corresponding XY coordinates
myRespXY <- DataSpecies[, c('X_WGS84', 'Y_WGS84')]

# Load environmental variables extracted from BIOCLIM (bio_3, bio_4, bio_7, bio_11 & bio_12)
myFiles <- paste0('external/bioclim/current/bio', c(3, 4, 7, 11, 12), '.grd')
myExpl <- raster::stack(system.file(myFiles, package = 'biomod2'))

\dontshow{
myExtent <- raster::extent(0,30,45,70)
myExpl <- raster::stack(raster::crop(myExpl, myExtent))
}

## ----------------------------------------------------------------------- #
file.out <- paste0(myRespName, "/", myRespName, ".AllModels.models.out")
if (file.exists(file.out)) {
  myBiomodModelOut <- get(load(file.out))
} else {

  # Format Data with true absences
  myBiomodData <- BIOMOD_FormatingData(resp.var = myResp,
                                       expl.var = myExpl,
                                       resp.xy = myRespXY,
                                       resp.name = myRespName)

  # Create default modeling options
  myBiomodOptions <- BIOMOD_ModelingOptions()

  # Model single models
  myBiomodModelOut <- BIOMOD_Modeling(bm.format = myBiomodData,
                                      modeling.id = 'AllModels',
                                      models = c('RF', 'GLM'),
                                      bm.options = myBiomodOptions,
                                      nb.rep = 2,
                                      data.split.perc = 80,
                                      metric.eval = c('TSS','ROC'),
                                      var.import = 3,
                                      do.full.models = FALSE,
                                      seed.val = 42)
}


## ----------------------------------------------------------------------- #
# Project single models
myBiomodProj <- BIOMOD_Projection(bm.mod = myBiomodModelOut,
                                  proj.name = 'Current',
                                  new.env = myExpl,
                                  models.chosen = 'all',
                                  metric.binary = 'all',
                                  metric.filter = 'all',
                                  build.clamping.mask = TRUE)
myBiomodProj
plot(myBiomodProj)


}
\seealso{
\code{\link{BIOMOD_Projection}}, \code{\link{BIOMOD_EnsembleForecasting}}

Other Toolbox objects: 
\code{\link{BIOMOD.ensemble.models.out}},
\code{\link{BIOMOD.formated.data.PA}},
\code{\link{BIOMOD.formated.data}},
\code{\link{BIOMOD.models.options}},
\code{\link{BIOMOD.models.out}},
\code{\link{BIOMOD.stored.data}},
\code{\link{biomod2_ensemble_model}},
\code{\link{biomod2_model}}
}
\author{
Damien Georges
}
\concept{Toolbox objects}
