% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hclu_diana.R
\name{hclu_diana}
\alias{hclu_diana}
\title{Divisive hierarchical clustering based on dissimilarity or beta-diversity}
\usage{
hclu_diana(
  dissimilarity,
  index = names(dissimilarity)[3],
  n_clust = NULL,
  cut_height = NULL,
  find_h = TRUE,
  h_max = 1,
  h_min = 0
)
}
\arguments{
\item{dissimilarity}{the output object from \code{\link[=dissimilarity]{dissimilarity()}} or
\code{\link[=similarity_to_dissimilarity]{similarity_to_dissimilarity()}}, or a \code{dist} object.
If a \code{data.frame} is used, the first two
columns represent pairs of sites (or any pair of nodes), and the next
column(s) are the dissimilarity indices.}

\item{index}{name or number of the dissimilarity column to use. By default,
the third column name of \code{dissimilarity} is used.}

\item{n_clust}{an \code{integer} or an \code{integer} vector indicating the number of
clusters to be obtained from the hierarchical tree, or the output from
\link{partition_metrics}. Should not be used at the same time as
\code{cut_height}.}

\item{cut_height}{a \code{numeric} vector indicating the height(s) at which the
tree should be cut. Should not be used at the same time as \code{n_clust}.}

\item{find_h}{a \code{boolean} indicating if the height of cut should be found for
the requested \code{n_clust}.}

\item{h_max}{a \code{numeric} indicating the maximum possible tree height for
the chosen \code{index}.}

\item{h_min}{a \code{numeric} indicating the minimum possible height in the tree
for the chosen \code{index}.}
}
\value{
A \code{list} of class \code{bioregion.clusters} with five slots:
\enumerate{
\item{\strong{name}: \code{character} containing the name of the algorithm}
\item{\strong{args}: \code{list} of input arguments as provided by the user}
\item{\strong{inputs}: \code{list} of characteristics of the clustering process}
\item{\strong{algorithm}: \code{list} of all objects associated with the
clustering procedure, such as original cluster objects}
\item{\strong{clusters}: \code{data.frame} containing the clustering results}}
}
\description{
This function computes a divisive hierarchical clustering from a
dissimilarity (beta-diversity) \code{data.frame}, calculates the cophenetic correlation
coefficient, and can get clusters from the tree if requested by the user.
The function implements randomization of the dissimilarity matrix to
generate the tree, with a selection method based on the optimal cophenetic
correlation coefficient. Typically, the dissimilarity \code{data.frame} is a
\code{bioregion.pairwise.metric} object obtained by running \code{similarity}
or \code{similarity} and then \code{similarity_to_dissimilarity}.
}
\details{
The function is based on \link[cluster:diana]{diana}.
Chapter 6 of Kaufman and Rousseeuw (1990) fully details the functioning of
the diana algorithm.

To find an optimal number of clusters, see \code{\link[=partition_metrics]{partition_metrics()}}
}
\examples{
comat <- matrix(sample(0:1000, size = 500, replace = TRUE, prob = 1/1:1001),
20, 25)
rownames(comat) <- paste0("Site",1:20)
colnames(comat) <- paste0("Species",1:25)

dissim <- dissimilarity(comat, metric = "all")

data("fishmat")
fishdissim <- dissimilarity(fishmat)
fish_diana <- hclu_diana(fishdissim, index = "Simpson")


}
\references{
\insertRef{Kaufman2009}{bioregion}
}
\seealso{
\link{cut_tree}
}
\author{
Pierre Denelle (\email{pierre.denelle@gmail.com}),
Boris Leroy (\email{leroy.boris@gmail.com}) and
Maxime Lenormand (\email{maxime.lenormand@inrae.fr})
}
