% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_bite.R
\encoding{UTF-8}
\name{mcmc_bite}
\alias{mcmc_bite}
\title{MCMC algorithm}
\usage{
mcmc_bite(model, log.file = "bite_mcmc.log", sampling.freq = 1000,
  print.freq = 1000, ncat = 1, beta.param = 0.3, ngen = 5e+06,
  burnin = 0)
}
\arguments{
\item{model}{an object of class "jive" or other objects from the bite package (see details)}

\item{log.file}{name of the output file that will store the log of MCMC chain}

\item{sampling.freq}{sampling frequency of the MCMC chain (how often chain will be saved into output file}

\item{print.freq}{printing frequency of the MCMC chain (how often chain will be printed in the R console). Setting it to 0 will suppress every printed message}

\item{ncat}{number of classes for thermodynamic integration (see details)}

\item{beta.param}{beta value to define classes for thermodynamic integration (see details)}

\item{ngen}{number of generation in MCMC chain}

\item{burnin}{a burning phase of MCMC chain (has to be specified for thermodynamic integration)}
}
\value{
Generates a log file in the users filespace at the path defined by log.file
}
\description{
Implements Markov chain Monte Carlo sampling for trait evolution models
}
\details{
This function runs MCMC sampling on jive object \code{\link{make_jive}} or objects describing other models of the bite package.
The jive object contains both the dataset and set of model to be used in MCMC. This function implements both a conventional MCMC
and an MCMC with thermodynamic integration. The latter option is turned off by default and can be changed by
setting ncat to values > 1. The recommended ncat for TI is 10. When setting ncat > 1, make sure to specify burning.
As a rule of thumb set burning to 1/10 fraction of ngen.
}
\examples{
 ## Load test data
 data(Anolis_traits)
 data(Anolis_tree)
 data(Anolis_map)
 
 ## Run a simple MCMC chain
 set.seed(300)
 my.jive <- make_jive(phy = Anolis_tree, traits = Anolis_traits[,-3],
  model.priors = list(mean = "BM", logvar= c("OU", "root")))
 bite_ex <- tempdir()
 logfile <- sprintf("\%s/my.jive_mcmc.log", bite_ex)
 mcmc_bite(model = my.jive, log.file=logfile,
 sampling.freq=10, print.freq=0, ngen=1000) 
  
 ## Run an MCMC chain with thermodynamic integration
 logfile <- sprintf("\%s/my.jive_mcmc_TI.log", bite_ex)
 mcmc_bite(my.jive, log.file=logfile, ncat=10, 
  sampling.freq=10, print.freq=100, ngen=1000, burnin=10) 
}
\author{
Theo Gaboriau, Anna Kostikova, Daniele Silvestro, and Simon Joly
}
