% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wclust.R
\name{wclust}
\alias{wclust}
\title{Compute dissimilarity between multiple wavelet spectra}
\usage{
wclust(w.arr, quiet = FALSE)
}
\arguments{
\item{w.arr}{\code{N x p x t} array of wavelet spectra where \code{N} is the
number of wavelet spectra to be compared, \code{p} is the number of periods
in each wavelet spectrum and \code{t} is the number of time steps in each
wavelet spectrum.}

\item{quiet}{Do not display progress bar.}
}
\value{
Returns a list containing:
  \item{diss.mat}{square dissimilarity matrix}
  \item{dist.mat}{(lower triangular) distance matrix}
}
\description{
Compute dissimilarity between multiple wavelet spectra
}
\references{
Rouyer, T., J. M. Fromentin, F. Menard, B. Cazelles, K. Briand, R. Pianet,
B. Planque, and N. C. Stenseth. 2008. Complex interplays among population
dynamics, environmental forcing, and exploitation in fisheries.
\emph{Proceedings of the National Academy of Sciences} 105:5420-5425.

Rouyer, T., J. M. Fromentin, N. C. Stenseth, and B. Cazelles. 2008.
Analysing multiple time series and extending significance testing in
wavelet analysis. \emph{Marine Ecology Progress Series} 359:11-23.
}
\author{
Tarik C. Gouhier (tarik.gouhier@gmail.com)
}
