% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design_matrix.R
\name{build_design}
\alias{build_design}
\title{Build the BLIN design matrix}
\usage{
build_design(Y, X = NULL, lag = 1, showWarnings = TRUE)
}
\arguments{
\item{Y}{Response 3-mode array.}

\item{X}{Optional 4-mode array of covariates, defaults to no covariates.}

\item{lag}{Optional numeric specifying autoregressive lag in model, defaults to 1.}

\item{showWarnings}{Optional logical whether matrix memory size should be evaluated and warning provided (see details), defaults to TRUE.}
}
\value{
\item{}{A sparse design matrix}
}
\description{
Build the BLIN design matrix
}
\details{
This function takes an \eqn{S \times L \times T} array \eqn{Y} that is a representation of a longitudinal bipartite relational data set. 
Optional input is an \eqn{S \times L \times T \times p} array  \eqn{X} of covariates that influence the evolution of the data set in equation over time.
The function returns an \eqn{(SL(T - lag)) \times (S^2 + L^2 + p)} design matrix, of sparse class, upon which \code{Y[,,lag:T]} may be regressed.
If \code{showWarnings = TRUE}, and if the estimated size of the design matrix is greater than 1GB, a warning is thrown.
}
\examples{
S <- 5
L <- 4
tmax <- 10
data <- generate_blin(S,L,tmax, lag=2, sparse=.8, seed=1)
dim(data$Y)

Xreg <- build_design(data$Y, data$X, lag=2)
dim(Xreg)
class(Xreg)

}
\seealso{
\code{\link{generate_blin}} \code{\link{blin_mle}}
}
\keyword{external}
