cat("\n\nRUnit test cases for bmer::blmer function with priors on the unmodeled coefficients\n\n");

# generated by:
if (FALSE) {
  set.seed(0);
  N <- 50;
  J.1 <- 5;
  J.2 <- 5;
  beta <- c(5, 2, 4);
  theta.1 <- matrix(rnorm(J.1 * 2), J.1, 2);
  theta.2 <- matrix(rnorm(J.2 * 3), J.2, 3);
  
  x.1 <- rnorm(N);
  x.2 <- rnorm(N);
  g.1 <- rmultinom(N, 1, runif(J.1));
  g.2 <- rmultinom(N, 1, runif(J.2));
  g.1 <- sapply(1:N, function(i) which(g.1[,i] == 1));
  g.2 <- sapply(1:N, function(i) which(g.2[,i] == 1));

  y <- rep(NA, N);
  for (i in 1:N) {
    y[i] <- 1 * (beta[1] + theta.1[g.1[i], 1] + theta.2[g.2[i], 1]) +
       x.1[i] * (beta[2] + theta.1[g.1[i], 2] + theta.2[g.2[i], 2]) +
       x.2[i] * (beta[3] +                      theta.2[g.2[i], 3]) +
       rnorm(1);
  }

  # ignored but still here
  weights <- runif(N);
  weights <- weights / sum(weights);
}


stMatricesToVector <- function(ST) {
  result <- rep(0, sum(sapply(ST, function(ST.i) { n <- nrow(ST.i); n * (n + 1) / 2 })));
  offset <- 0;
  for (i in 1:length(ST)) {
    factorDimension <- nrow(ST[[i]]);
    
    result[(1 + offset):(factorDimension + offset)] <- diag(ST[[i]]);
    offset <- offset + factorDimension;
    if (factorDimension == 1) next;
    
    lowerTriangleLength <- factorDimension * (factorDimension - 1) / 2;
    result[(1 + offset):(lowerTriangleLength + offset)] <- ST[[i]][lower.tri(ST[[i]])];
    offset <- offset + lowerTriangleLength;
  }
  
  return(result);
}

if (FALSE) {
  getBlockCovariance <- function(Sigmas, totalNumModeledParameters, numGroups) {
    numLevels <- length(Sigmas);

    numNonZeroEntries <- sum(sapply(1:numLevels, function(k) { return(dim(Sigmas[[k]])[1]^2 * numGroups[k]) }));
    rowIndices <- rep(0, numNonZeroEntries);
    colIndices <- rep(0, numNonZeroEntries);
    values <- rep(0, numNonZeroEntries);

    sparseIndex <- 1;
    upperLeftIndex <- 1;
    for (k in 1:numLevels) {
      numModeledParameters <- dim(Sigmas[[k]])[1];
      numValues <- numModeledParameters^2;
      
      for (j in 1:numGroups[k]) {
        rowIndices[sparseIndex:(sparseIndex + numValues - 1)] <-
          rep(upperLeftIndex:(upperLeftIndex + numModeledParameters - 1),
              numModeledParameters);
        colIndices[sparseIndex:(sparseIndex + numValues - 1)] <-
          as.vector(t(matrix(rep(upperLeftIndex:(upperLeftIndex + numModeledParameters - 1)),
                             numModeledParameters, numModeledParameters)));
        values[sparseIndex:(sparseIndex + numValues - 1)] <-
          as.vector(Sigmas[[k]]);
        
        sparseIndex <- sparseIndex + numValues;
        upperLeftIndex <- upperLeftIndex + numModeledParameters;
      }
    }
  
    return(sparseMatrix(rowIndices, colIndices, x=values));
  }

  getPermutationFromLmerToBlock <- function(numFactors, numGroupsPerFactor, numModeledParametersPerFactor) {
    indices <- rep(0, sum(numGroupsPerFactor * numModeledParametersPerFactor));
  
    index <- 1;
    offset <- 0;
    for (k in 1:numFactors) {
      for (l in 1:numModeledParametersPerFactor[k]) {
        for (j in 1:numGroupsPerFactor[k]) {
          indices[index] <- offset + l + (j - 1) * numModeledParametersPerFactor[k];
          index <- index + 1;
        }
      }
      offset <- offset + numModeledParametersPerFactor[k] * numGroupsPerFactor[k];
    }
    return(indices);
  }

  rotateSparseDesignMatrix <- function(model) {
    factorDimensions <- sapply(model@ST, nrow);
    numGroupsPerFactor <- (model@Gp[-1] - model@Gp[-length(model@Gp)]) / factorDimensions;
    
    S <- lapply(model@ST, function(matrix) diag(diag(matrix), nrow(matrix)));
    T <- lapply(model@ST, function(matrix) { diag(matrix) <- rep(1, nrow(matrix)); matrix });
    
    Lambdas <- lapply(1:length(S), function(i) T[[i]] %*% S[[i]])
    Lambda <- getBlockCovariance(Lambdas, sum(factorDimensions * numGroupsPerFactor), numGroupsPerFactor)
    perm <- as(getPermutationFromLmerToBlock(length(numGroupsPerFactor), numGroupsPerFactor,
                                             factorDimensions), "pMatrix")
    
    return(perm %*% t(Lambda) %*% t(perm) %*% model@Zt);
  }

  computeAugmentedDesignFactorizations <- function(model) {
    if (length(model@sqrtXWt) > 0) {
      W <- Diagonal(nrow(model@X), model@sqrtXWt);
    } else {
      W <- Diagonal(nrow(model@X));
    }
    X.w <- W %*% model@X
    C <- model@A %*% W
    P <- as(model@L@perm + 1, "pMatrix")
    
    L <- Cholesky(tcrossprod(P %*% C), Imult=1, LDL=FALSE, perm=FALSE);
    L@perm <- model@L@perm;
    L@type[1] <- as.integer(2);

    RZX <- as(solve(L, P %*% C %*% X.w, "L"), "matrix");

    if (model@fixef.prior@type == 0) {
      RX <- as(chol(crossprod(X.w) - crossprod(RZX)), "matrix");
    } else {
      RXPartial <- crossprod(X.w) - crossprod(RZX);
      
      sigma.sq <- ifelse(model@dims[["REML"]], model@deviance[["sigmaREML"]], model@deviance[["sigmaML"]])^2;
      hyperparameters <- model@fixef.prior@hyperparameters;
      if (length(hyperparameters) == 1) {
        Sigma.beta.inv <- diag(hyperparameters^2, ncol(model@X))
      } else if (length(hyperparameters) == ncol(model@X)) {
        Sigma.beta.inv <- diag(hyperparameters^2);
      } else {
        matrixLength <- ncol(model@X)^2;
        Sigma.beta.inv <- matrix(hyperparameters[1:matrixLength + matrixLength], ncol(model@X), ncol(model@X));
      }
      RX <- as(chol(RXPartial + sigma.sq * Sigma.beta.inv), "matrix");
    }
    
    return(list(L = L, RZX = RZX, RX = RX));
  }
  
  calculateJointMode <- function(model) {
    C <- model@A;
    
    if (length(model@sqrtXWt) > 0) {
      W <- Diagonal(nrow(model@X), model@sqrtXWt);
      C@x <- model@Cx;
    } else {
      W <- Diagonal(nrow(model@X));
    }
    
    Y.w <- W %*% model@y;
    X.w <- W %*% model@X;
    
    P <- as(model@L@perm + 1, "pMatrix");
    
    theta.tilde <- solve(model@L, P %*% C %*% Y.w, "L");
    beta.tilde <- solve(t(model@RX), crossprod(X.w, Y.w) - crossprod(model@RZX, theta.tilde));
    
    beta.hat <- as(solve(model@RX, beta.tilde), "numeric");
    theta.hat <- as(solve(model@L, theta.tilde - model@RZX %*% beta.hat, "Lt"), "numeric");

    pwrss <- (crossprod(Y.w) - (crossprod(theta.tilde) +
                                crossprod(beta.tilde)))[1];
    
    return(list(beta.hat = beta.hat, theta.hat = theta.hat,
                beta.tilde = beta.tilde, theta.tilde = theta.tilde,
                pwrss = pwrss));
  }

  calculateDeviances <- function(model) {
    C <- model@A;
    
    if (length(model@sqrtXWt) > 0) {
      W <- Diagonal(nrow(model@X), model@sqrtXWt);
      C@x <- model@Cx;
    } else {
      W <- Diagonal(nrow(model@X));
    }
    
    Y.w <- W %*% model@y;
    X.w <- W %*% model@X;
    
    P <- as(model@L@perm + 1, "pMatrix");
    
    theta.hat <- model@u;
    beta.hat <- model@fixef;
    
    model@deviance[["usqr"]] <- crossprod(model@u)[1];
    model@deviance[["wrss"]] <- model@deviance[["pwrss"]] - model@deviance[["usqr"]];
    
    degreesOfFreedom <- nrow(X.w);

    if (model@fixef.prior@type == 0) {
      model@deviance[["sigmaML"]] <- sqrt(model@deviance[["pwrss"]] / degreesOfFreedom);
      sigma.sq <- model@deviance[["sigmaML"]]^2;
      
      model@deviance[["ML"]] <- model@deviance[["ldL2"]] +
        degreesOfFreedom * (1 + log(2 * pi * sigma.sq));
    } else {
      sigma.sq <- model@deviance[["sigmaML"]]^2;

      model@deviance[["ML"]] <- degreesOfFreedom * log(2 * pi * sigma.sq) + model@deviance[["pwrss"]] / sigma.sq + model@deviance[["ldL2"]];
    }

    degreesOfFreedom <- nrow(X.w) - ncol(X.w);

    if (model@fixef.prior@type == 0) {
      model@deviance[["sigmaREML"]] <- sqrt(model@deviance[["pwrss"]] / degreesOfFreedom);
      sigma.sq <- model@deviance[["sigmaREML"]]^2;
      
      model@deviance[["REML"]] <- model@deviance[["ldL2"]] + model@deviance[["ldRX2"]] +
        degreesOfFreedom * (1 + log( 2 * pi * sigma.sq));
    } else {
      sigma.sq <- model@deviance[["sigmaREML"]]^2;

      model@deviance[["REML"]] <- degreesOfFreedom * log(2 * pi * sigma.sq) + model@deviance[["pwrss"]] / sigma.sq + model@deviance[["ldL2"]] + model@deviance[["ldRX2"]];
    }

    return(model@deviance);
  }

  stVectorToMatrices <- function(parameters, numFactors, factorDimensions) {
    ST <- list();
    offset <- 0;
    for (i in 1:numFactors) {
      factorDimension <- factorDimensions[i];
      
      ST.i <- diag(parameters[(1 + offset):(factorDimension + offset)], factorDimension);
      offset <- offset + factorDimension;

      if (factorDimension > 1) {
        lowerTriangleLength <- factorDimension * (factorDimension - 1) / 2;
        ST.i[lower.tri(ST.i)] <- parameters[(1 + offset):(lowerTriangleLength + offset)];
        offset <- offset + lowerTriangleLength;
      }

      ST[[i]] <- ST.i;
    }

    return(ST);
  }
  
  deviance <- function(parameters, model) {
    if (model@fixef.prior@type[1] != 0) {
      stParameters <- parameters[-length(parameters)];
      if (model@dims[["REML"]]) {
        model@deviance[["sigmaREML"]] <- parameters[length(parameters)];
      } else {
        model@deviance[["sigmaML"]] <- parameters[length(parameters)];
      }
    } else {
      stParameters <- parameters;
    }
    
    model@ST <- stVectorToMatrices(stParameters, model@dims[["nt"]], sapply(model@ST, nrow));
    model@A <- rotateSparseDesignMatrix(model);
    factorizations <-  computeAugmentedDesignFactorizations(model);
    model@L <- factorizations$L;
    model@RZX <- factorizations$RZX;
    model@RX <- factorizations$RX;

    model@deviance[["ldL2"]] <- 2.0 * determinant(model@L, logarithm=TRUE)$modulus;
    model@deviance[["ldRX2"]] <- 2.0 * determinant(model@RX, logarithm=TRUE)$modulus;

    modes <- calculateJointMode(model);

    model@fixef <- modes$beta.hat;
    model@u <- modes$theta.hat;
    model@deviance[["pwrss"]] <- modes$pwrss;

    model@deviance <- calculateDeviances(model);

    if (model@dims[["REML"]]) return(model@deviance[["REML"]]);
    return(model@deviance[["ML"]]);
  }
}

test.bmer.blmer.fixefPrior <- function()
{
  x.1 <- c(0.503607972233726, 1.08576936214569, -0.69095383969683, -1.28459935387219, 0.046726172188352, -0.235706556439501, -0.542888255010254, -0.433310317456782, -0.649471646796233, 0.726750747385451, 1.1519117540872, 0.992160365445798, -0.429513109491881, 1.23830410085338, -0.279346281854269, 1.75790308981071, 0.560746090888056, -0.452783972553158, -0.832043296117832, -1.16657054708471, -1.0655905803883, -1.563782051071, 1.15653699715018, 0.83204712857239, -0.227328691424755, 0.266137361672105, -0.376702718583628, 2.44136462889459, -0.795339117255372, -0.0548774737115786, 0.250141322854153, 0.618243293566247, -0.172623502645857, -2.22390027400994, -1.26361438497058, 0.358728895971352, -0.0110454784656636, -0.940649162618608, -0.115825322156954, -0.814968708869917, 0.242263480859686, -1.4250983947325, 0.36594112304922, 0.248412648872596, 0.0652881816716207, 0.0191563916602738, 0.257338377155533, -0.649010077708898, -0.119168762418038, 0.66413569989411);

  x.2 <- c(1.10096910219409, 0.14377148075807, -0.117753598165951, -0.912068366948338, -1.43758624082998, -0.797089525071965, 1.25408310644997, 0.77214218580453, -0.21951562675344, -0.424810283377287, -0.418980099421959, 0.996986860909106, -0.275778029088027, 1.2560188173061, 0.646674390495345, 1.29931230256343, -0.873262111744435, 0.00837095999603331, -0.880871723252545, 0.59625901661066, 0.119717641289537, -0.282173877322451, 1.45598840106634, 0.229019590694692, 0.996543928544126, 0.781859184600258, -0.776776621764597, -0.615989907707918, 0.0465803028049967, -1.13038577760069, 0.576718781896486, -1.28074943178832, 1.62544730346494, -0.500696596002705, 1.67829720781629, -0.412519887482398, -0.97228683550556, 0.0253828675878054, 0.0274753367451927, -1.68018272239593, 1.05375086302862, -1.11959910457218, 0.335617209968815, 0.494795767113158, 0.138052708711737, -0.118792025778828, 0.197684262345795, -1.06869271125479, -0.80321321736474, -1.11376513631953);

  y <- c(10.2556670398245, 5.77156184409445, 5.2388963179889, -1.01048113754769, -2.40694356326161, 4.87659537730766, 11.0678751360507, 9.95236105245466, -1.21089148312542, 5.80498258814754, 0.684860586400015, 11.0298099678496, 5.71308913175892, 16.7456124781686, 7.4731450675828, 8.51093715973169, 2.82372959757841, 4.3443694315618, -2.96487863376567, 5.88586538048499, 0.976211065859574, 5.62948932886417, 13.6141669016732, 6.07894540274009, 9.57669016288729, 8.56529931086956, 2.02623726516967, 5.335419611075, 5.49337753963837, 0.357086593483832, 5.90421996841909, -0.0078591135781455, 12.5466815499627, -6.66182740887203, 11.9526738840087, 1.5017901567396, 1.15948360785528, 4.97438059345444, 5.91648438771629, 0.262312751711231, 10.5968851648003, -0.281646718883028, 7.38808913061462, 7.91783952393784, 6.24106797266484, 4.86354361177658, 5.04480479030089, 3.28778785631259, 1.36283750127861, -1.0792461964562);

  # weights <- c(0.00381387665222907, 0.00253068543212147, 0.0268842109172576, 0.026049490821392, 0.0352712496034507, 0.0117640131347288, 0.0363732801784418, 0.00787598233773136, 0.030897454488213, 0.00875908253475443, 0.00119929989101133, 0.0336135432129502, 0.0267145955150939, 0.0367345999917109, 0.0263537615646393, 0.032876028309309, 0.0141114448422329, 0.0152996366814835, 0.0221359992277507, 0.00371029472391699, 0.00755627846850136, 0.0229306433039551, 0.0293036198379298, 0.0338164933835516, 0.0144975389380483, 0.0311484072530266, 0.00227387001104692, 0.024309809307476, 0.0139066217356676, 0.0229252442673684, 0.0356314693890261, 0.00777690684240461, 0.0143917847174194, 0.0261804195195157, 0.0299524830990098, 0.0203641783916231, 0.0322893691793644, 0.0205532146881175, 0.0195650713155693, 0.0163761413827575, 0.0141272019645207, 0.00481289927179461, 0.0116262989351509, 0.0107885265538658, 0.0308614744202712, 0.0303438490551224, 0.00560673910867697, 0.0201020606053731, 0.0232883713494038, 0.0197244836440227);

  g.1 <- c(5, 2, 4, 4, 5, 5, 4, 3, 5, 5, 2, 3, 4, 5, 2, 2, 5, 1, 5, 2, 5, 1, 1, 1, 1, 1, 2, 1, 3, 5, 2, 1, 4, 5, 4, 2, 2, 2, 4, 3, 3, 3, 1, 5, 1, 4, 2, 3, 1, 2);
  g.2 <- c(3, 4, 1, 2, 4, 1, 1, 4, 3, 3, 3, 3, 1, 4, 3, 3, 2, 3, 3, 2, 4, 3, 4, 3, 3, 1, 3, 4, 3, 3, 3, 2, 3, 3, 2, 3, 3, 3, 4, 1, 4, 3, 3, 3, 4, 5, 2, 1, 3, 3);
  
  options(warn = -1);
  testModel <- blmer(y ~ x.1 + x.2 + (1 + x.1 | g.1) + (1 + x.1 + x.2 | g.2),
                     control=list(maxIter=0L),
                     cov.prior = NULL,
                     fixef.prior = NULL);
  options(warn = 0);

  if (FALSE) {
    lowerBounds <- unlist(sapply(testModel@ST, function(m) { n <- nrow(m); cons1 <- rep(0, n); cons2 <- rep(-Inf, n * (n - 1) / 2); return(c(cons1, cons2)) }))
    upperBounds <- unlist(sapply(testModel@ST, function(m) { n <- nrow(m); return(rep(Inf, n * (n + 1) / 2)) } ))
    
    optimResults <- optim(stMatricesToVector(testModel@ST), deviance, lower=lowerBounds, upper=upperBounds,
                          method="L-BFGS-B", model = testModel, control=list(factr=1e-10));
  } else {
    optimResults <- list(par = c(0.685799044462457, 2.08564836455654, -0.373384009803916, 0.756409362533568, 0.715198411044111, 0, -0.42926488178236, -0.820611020573745, 0.690451180666571));
  }
    
  blmerFit <- blmer(y ~ x.1 + x.2 + (1 + x.1 | g.1) + (1 + x.1 + x.2 | g.2),
                    cov.prior = NULL,
                    fixef.prior = NULL);
    
  checkEquals(stMatricesToVector(blmerFit@ST), optimResults$par, tolerance=1e-5);

  
  options(warn = -1);
  testModel <- blmer(y ~ x.1 + x.2 + (1 + x.1 | g.1) + (1 + x.1 + x.2 | g.2),
                     control=list(maxIter=0L),
                     cov.prior = NULL,
                     fixef.prior = "normal(sd=1)");
  options(warn = 0);

  if (FALSE) {
    lowerBounds <- append(lowerBounds, 0);
    upperBounds <- append(upperBounds, Inf);
    startingParameters <- c(stMatricesToVector(testModel@ST), testModel@deviance[["sigmaREML"]])
    optimResults <- optim(startingParameters, deviance, lower=lowerBounds, upper=upperBounds,
                          method="L-BFGS-B", model = testModel, control=list(factr=1e-10));
  } else {
    optimResults <- list(par = c(0.638288851794637, 1.93169678693141, -0.420475711726189, 5.04397623008121, 0.831563516540545, 0.496972863151094, 0.291251083711676, 0.768201375102488, 1.41639143221261, 0.923663020710309));
  }
  
  blmerFit <- blmer(y ~ x.1 + x.2 + (1 + x.1 | g.1) + (1 + x.1 + x.2 | g.2),
                    cov.prior = NULL,
                    fixef.prior = "normal(sd=1)");

  checkEquals(stMatricesToVector(blmerFit@ST), optimResults$par[-length(optimResults$par)], tolerance=1e-3);
  
  
  
  # check even that these run without error
  options(warn = 2);
  ignored <- blmer(Reaction ~ Days + (1 + Days|Subject), sleepstudy,
                   cov.prior = NULL,
                   fixef.prior = "normal");
  ignored <- blmer(Reaction ~ Days + (1 + Days|Subject), sleepstudy,
                   cov.prior = NULL,
                   fixef.prior = "normal(cov = diag(0.5, 2), posterior.scale='absolute')");
  options(warn = 0);
}
