% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{mlm_summary}
\alias{mlm_summary}
\title{Print a summary of the estimated multilevel mediation model}
\usage{
mlm_summary(mod = NULL, level = 0.99, ref_val = 0, pars = c("a", "b",
  "cp", "ab", "c", "pme", "covab", "corrab"), digits = 2)
}
\arguments{
\item{mod}{A \code{stanfit} object obtained from \code{mlm()}}

\item{level}{"Confidence" level; Defines the limits of the credible intervals.
Defaults to .99 (i.e. displays 99\% CIs.)}

\item{ref_val}{Obtain posterior probabilities that parameters are in the
observed direction from \code{ref_val}. Defaults to 0.}

\item{pars}{Parameters to summarize. Defaults to main average-level
parameters. See Details for more information.}

\item{digits}{How many decimal points to display in the output. Defaults to 2.}
}
\value{
A \code{data.frame} summarizing the estimated multilevel
mediation model:
\describe{
 \item{Parameter}{Name of parameter}
 \item{Mean}{Mean of parameter's posterior distribution.}
 \item{Median}{Median of parameter's posterior distribution.}
 \item{SD}{Standard deviation of parameter's posterior distribution.}
 \item{ci_lwr}{The lower limit of Credible Intervals.}
 \item{ci_upr}{The upper limit of Credible Intervals.}
 \item{pprob}{Posterior probability.}
 \item{n_eff}{Number of efficient samples.}
 \item{Rhat}{Should be 1.00.}
}
}
\description{
Prints the estimated parameters (numerical summaries of the marginal
posterior distributions).
}
\details{
After estimating a model (drawing samples from the joint posterior
probability distribution) with \code{mlm()}, show the estimated results
by using \code{mlm_summary(fit)}, where "fit" is an object containing
the fitted model.

The function shows, for each parameter specified with \code{pars},
the posterior mean, and limits of the Credible Interval as specified
by \code{level}. For example, \code{level = .91} shows a
91\% Credible Interval, which summarizes the central 91\% mass of
the marginal posterior distribution.

\subsection{Parameters}{
By default, \code{mlm()} estimates and returns a large number of parameters,
including the varying effects, and their associated standard deviations.
However, \code{mlm_summay()} by default only displays a subset of the
estimated parameters:

\describe{
 \item{a}{Regression slope of the X -> M relationship.}
 \item{b}{Regression slope of the M -> Y relationship.}
 \item{cp}{Regression slope of the X -> Y relationship.
 (The direct effect.)}
 \item{ab}{Mediated effect (\code{a * b}).}
 \item{c}{Total effect of X on Y. ( \eqn{cp + ab + \sigma_ab} )}
 \item{pme}{Percent mediated effect.}
 \item{covab}{Estimated covariance of the
 participant-level a_j and b_j parameters.}
 \item{corrab}{Estimated correlation of the
 participant-level a_j and b_j parameters.}
}
The user may specify \code{pars = NULL} to display all estimated parameters.
Other options include e.g. \code{pars = "tau"} to display the varying
effects' standard deviations.

To learn more about the additional parameters, refer to the Stan code
(\code{cat(get_stancode(fit))}).
}
}
\author{
Matti Vuorre \email{mv2521@columbia.edu}
}

