\name{graph generation tools}
\alias{empty.graph}
\alias{random.graph}
\title{ Generate an empty or random graph }
\description{
  Generate an empty or random graph from a given set of nodes.
}
\usage{
  empty.graph(nodes, num = 1)
  random.graph(nodes, num = 1, method = "ordered", ..., debug = FALSE)
}
\arguments{
  \item{nodes}{a vector of character strings, the labels of the nodes.}
  \item{num}{an integer, the number of graphs to be generated.}
  \item{method}{a character string, the label of a score.
      Possible values are \code{ordered} (\emph{full ordering} based 
      generation), \code{ic-dag} (Ide's and Cozman's 
      \emph{Generating Multi-connected DAGs} algorithm) and \code{empty}
      (generates empty graphs).}
  \item{\dots}{additional tuning parameters (see below).}
  \item{debug}{a boolean value. If \code{TRUE} a lot of debugging output
       is printed; otherwise the function is completely silent.}
}
\details{

  Available graph generation algorithms are:

  \itemize{

    \item \emph{full ordering} based generation (\code{ordered}): 
        generates graphs whose node ordering is given by the order of 
        the labels in the \code{nodes} parameter. The same algorithm 
        is used in the \code{randomDAG} function in package \pkg{pcalg}.

    \item Ide's and Cozman's \emph{Generating Multi-connected DAGs} 
        algorithm (\code{ic-dag}): generates graphs with a uniform
        probability distribution over the set of multiconnected 
        graphs.

    \item \emph{empty graphs} (\code{empty}): generates graphs without
        any arc.

  }

  Additional parameters for the \code{random.graph} function are:

  \itemize{

    \item \code{prob}: the probability of each arc to be present in
        a graph generated by the \code{ordered} algorithm. The default
        value is \code{0.5}.

    \item \code{burn.in}: the number of iteration for the \code{ic-dag}
        algorithm to converge to a stationary (and uniform) probability
        distribution. The default value is \code{6 * length(nodes)^2}.

    \item \code{max.degree}: the maximum degree for any node in a graph
        generated by the \code{ic-dag} algorithm. The default value is
        \code{Inf}.

    \item \code{max.in.degree}: the maximum in-degree for any node in 
        a graph generated by the \code{ic-dag} algorithm. The default 
        value is \code{Inf}.

    \item \code{max.out.degree}: the maximum out-degree for any node in 
        a graph generated by the \code{ic-dag} algorithm. The default 
        value is \code{Inf}.

  }

}
\value{

  Both \code{empty.graph} and \code{random.graph} return an
  object of class \code{bn} (if \code{num} is equal to \code{1})
  or a list of objects of class \code{bn} (otherwise).

}
\references{

  J.S. Ide and F.G. Cozman. Generating Random Bayesian Networks. Proceedings 
    on 16th Brazilian Symposium on Artificial Intelligence (SBIA 2002), 
    Advances in Artificial Intelligence, Springer-Verlag, Berlin, p. 366-375, 
    November, 2002. 

}
\examples{
empty.graph(LETTERS[1:8])
#
#  Randomly generated Bayesian network
#
#  model:
#    [A][B][C][D][E][F][G][H] 
#  nodes:                                 8 
#  arcs:                                  0 
#    undirected arcs:                     0 
#    directed arcs:                       0 
#  average markov blanket size:           0.00 
#  average neighbourhood size:            0.00 
#  average branching factor:              0.00 
#
#  generation algorithm:                  empty 
#
random.graph(LETTERS[1:8])
# <insert the description of a random graph here>
plot(random.graph(LETTERS[1:8], method = "ic-dag", max.in.degree = 2))
plot(random.graph(LETTERS[1:8]))
plot(random.graph(LETTERS[1:8], prob = 0.2))
}
\author{ Marco Scutari }
\keyword{utilities}
\keyword{graphs}
