% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parent_child_monitor.R
\name{seq_pa_ch_monitor}
\alias{seq_pa_ch_monitor}
\title{Sequential parent-child node monitors}
\usage{
seq_pa_ch_monitor(dag, df, node.name, pa.names, pa.val, alpha = "default")
}
\arguments{
\item{dag}{an object of class \code{bn} from the \code{bnlearn} package}

\item{df}{a base R style dataframe}

\item{node.name}{node over which to compute the monitor}

\item{pa.names}{vector including the names of the parents of \code{node.name}}

\item{pa.val}{vector including the levels of \code{pa.names} considered}

\item{alpha}{single integer. By default, the number of max levels in \code{df}}
}
\value{
A vector including the scores \eqn{Z_{ij}}.
}
\description{
Sequential node monitor for a vertex of a Bayesian network for a specific configuration of its parents
}
\details{
Consider a Bayesian network over variables \eqn{Y_1,\dots,Y_m} and suppose a dataset \eqn{(\boldsymbol{y}_1,\dots,\boldsymbol{y}_n)} has been observed, where \eqn{\boldsymbol{y}_i=(y_{i1},\dots,y_{im})} and \eqn{y_{ij}} is the i-th observation of the j-th variable.
Consider a configuration \eqn{\pi_j} of the parents and consider the sub-vector \eqn{\boldsymbol{y}'=(\boldsymbol{y}_1',\dots,\boldsymbol{y}_{N'}')} of \eqn{(\boldsymbol{y}_1,\dots,\boldsymbol{y}_n)} including observations where the parents of \eqn{Y_j} take value \eqn{\pi_j} only.
Let \eqn{p_i(\cdot|\pi_j)} be the conditional distribution of \eqn{Y_j} given that its parents take value \eqn{\pi_j} after the first i-1 observations have been processed. Define
\deqn{E_i = \sum_{k=1}^Kp_i(d_k|\pi_j)\log(p_i(d_k|\pi_j)),}
\deqn{V_i = \sum_{k=1}^K p_i(d_k|\pi_j)\log^2(p_i(d_k|\pi_j))-E_i^2,}
where \eqn{(d_1,\dots,d_K)} are the possible values of \eqn{Y_j}. The sequential parent-child node monitor for the vertex \eqn{Y_j} and parent configuration \eqn{\pi_j} is defined as
 \deqn{Z_{ij}=\frac{-\sum_{k=1}^i\log(p_k(y_{kj}'|\pi_j))-\sum_{k=1}^i E_k}{\sqrt{\sum_{k=1}^iV_k}}.}
 Values of \eqn{Z_{ij}} such that \eqn{|Z_{ij}|> 1.96} can give an indication of a poor model fit for the vertex \eqn{Y_j} after the first i-1 observations have been processed.
}
\examples{
seq_pa_ch_monitor(chds_bn, chds, "Events", "Social", "High", 3)

}
\references{
Cowell, R. G., Dawid, P., Lauritzen, S. L., & Spiegelhalter, D. J. (2006). Probabilistic networks and expert systems: Exact computational methods for Bayesian networks. Springer Science & Business Media.

Cowell, R. G., Verrall, R. J., & Yoon, Y. K. (2007). Modeling operational risk with Bayesian networks. Journal of Risk and Insurance, 74(4), 795-827.
}
\seealso{
\code{\link{influential_obs}}, \code{\link{node_monitor}}, \code{\link{seq_node_monitor}}, \code{\link{seq_pa_ch_monitor}}
}
