% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_genotypes_admix.R
\name{draw_genotypes_admix}
\alias{draw_genotypes_admix}
\title{Draw genotypes from the admixture model}
\usage{
draw_genotypes_admix(p_ind, admix_proportions = NULL)
}
\arguments{
\item{p_ind}{The \eqn{m \times n}{m-by-n} IAF matrix (if \code{admix_proportions} is missing) or the \eqn{m \times k}{m-by-k} intermediate subpopulation allele frequency matrix (if \code{admix_proportions} is present)}

\item{admix_proportions}{The optional \eqn{n \times k}{n-by-k} admixture proportion matrix}
}
\value{
The \eqn{m \times n}{m-by-n} genotype matrix
}
\description{
Given the Individual-specific Allele Frequency (IAF) \eqn{\pi_{ij}} for locus \eqn{i} and individual \eqn{j}, genotypes are drawn binomially:
\deqn{x_{ij}|\pi_{ij} \sim \mbox{Binomial}(2, \pi_{ij}).}
Below \eqn{m} is the number of loci, \eqn{n} the number of individuals, and \eqn{k} the number of intermediate subpopulations.
If an admixture proportion matrix \eqn{Q} is provided as the second argument, the first argument \eqn{P} is treated as the intermediate subpopulation allele frequency matrix and the IAF matrix is given by
\deqn{P Q^T.}{P \%*\% t(Q).}
However, in this case the IAF matrix is computed in parts only, never stored in full, greatly reducing memory usage.
If \eqn{Q} is missing, then \eqn{P} is treated as the IAF matrix.
}
\examples{
# dimensions
# number of loci
m_loci <- 10
# number of individuals
n_ind <- 5
# number of intermediate subpops
k_subpops <- 2

# define population structure
# FST values for k = 2 subpops
inbr_subpops <- c(0.1, 0.3)
# non-trivial admixture proportions
admix_proportions <- admix_prop_1d_linear(n_ind, k_subpops, sigma = 1)

# draw allele frequencies
# vector of ancestral allele frequencies
p_anc <- draw_p_anc(m_loci)

# matrix of intermediate subpop allele freqs
p_subpops <- draw_p_subpops(p_anc, inbr_subpops)

# matrix of individual-specific allele frequencies
p_ind <- make_p_ind_admix(p_subpops, admix_proportions)

# draw genotypes from intermediate subpops (one individual each)
X_subpops <- draw_genotypes_admix(p_subpops)

# and genotypes for admixed individuals
X_ind <- draw_genotypes_admix(p_ind)

# draw genotypes for admixed individuals without p_ind intermediate
# (p_ind is computed internally in parts, never stored in full,
# reducing memory use substantially)
X_ind <- draw_genotypes_admix(p_subpops, admix_proportions)

}
