% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/BNDataset-methods.R
\docType{methods}
\name{complete}
\alias{complete}
\alias{complete,BNDataset}
\alias{complete,BNDataset-method}
\title{Subset a \code{\link{BNDataset}} to get only complete cases.}
\usage{
complete(x, complete.vars = seq_len(num.variables(x)))

\S4method{complete}{BNDataset}(x, complete.vars = seq_len(num.variables(x)))
}
\arguments{
\item{x}{a \code{\link{BNDataset}}.}

\item{complete.vars}{vector containing the indices of the variables to be considered
for the subsetting; variables not included in the vector can still contain \code{NA}s.}
}
\value{
a copy of the original \code{\link{BNDataset}} containing only complete observations.
}
\description{
Given a \code{\link{BNDataset}}, return a copy of the original object where
the \code{raw.data} consists only in the observations that do not contain missing values.
}
\details{
Non-missingness can be required on a subset of variables (by default, on all variables).

If present, imputed data and bootstrap samples are eliminated from the
new \code{\link{BNDataset}}, as using this method *after* using \code{\link{impute}}
or \code{\link{bootstrap}}, there may likely be a loss of correspondence between
the subsetted \code{raw.data} and the previously generated \code{imputed.data}
and \code{bootstrap} samples.
}

