% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/BNDataset-methods.R
\docType{methods}
\name{has.raw.data}
\alias{has.raw.data}
\alias{has.raw.data,BNDataset-method}
\alias{has.raw.data,BNDataset}
\title{check if a BNDataset contains raw data.}
\usage{
has.raw.data(x)

\S4method{has.raw.data}{BNDataset}(x)
}
\arguments{
\item{x}{a \code{\link{BNDataset}}.}
}
\description{
Check whether a \code{\link{BNDataset}} object actually contains raw data.
}
\examples{
\dontrun{
x <- BNDataset()
has.raw.data(x) # FALSE

x <- read.dataset(x, "file.header", "file.data")
has.raw.data(x) # TRUE, since read.dataset() actually reads raw data.
}

}
\seealso{
\code{\link{has.imputed.data}}, \code{\link{raw.data}}, \code{\link{imputed.data}}
}
