#' @rdname html_document2
#' @export
markdown_document2 = function(
  number_sections = TRUE, fig_caption = TRUE, md_extensions = NULL,
  global_numbering = !number_sections, pandoc_args = NULL, ...,
  base_format = rmarkdown::md_document
) {
  from = rmarkdown::from_rmarkdown(fig_caption, md_extensions)

  config = get_base_format(base_format, list(
    number_sections = number_sections, fig_caption = fig_caption,
    md_extensions = md_extensions, pandoc_args = pandoc_args, ...
  ))

  # for docx, Pandoc 2.14.1 numbers figures/tables globally from 1 to n (#1223)
  if (!global_numbering && rmarkdown::pandoc_available('2.14.1') &&
      identical(base_format, rmarkdown::word_document)) {
    if (!missing(global_numbering)) warning(
      "'global_numbering = FALSE' does not work for Word output with Pandoc >= 2.14.1; ",
      "Using 'TRUE' instead."
    )
    global_numbering = TRUE
  }

  pre = config$pre_processor
  config$pre_processor = function(metadata, input_file, ...) {
    process_markdown(input_file, from, pandoc_args, global_numbering)
    if (is.function(pre)) pre(metadata, input_file, ...)
  }
  post = config$post_processor
  config$post_processor = function(metadata, input, output, clean, verbose) {
    if (is.function(post)) output = post(metadata, input, output, clean, verbose)
    move_output(output)
  }
  config = common_format_config(config, config$pandoc$to)
  config
}

#' @rdname html_document2
#' @export
context_document2 = function(...) {
  markdown_document2(..., base_format = rmarkdown::context_document)
}

#' @rdname html_document2
#' @export
github_document2 = function(...) {
  markdown_document2(..., base_format = rmarkdown::github_document)
}

#' @rdname html_document2
#' @export
odt_document2 = function(...) {
  markdown_document2(..., base_format = rmarkdown::odt_document)
}

#' @rdname html_document2
#' @export
powerpoint_presentation2 = function(...) {
  markdown_document2(..., base_format = rmarkdown::powerpoint_presentation)
}

#' @rdname html_document2
#' @export
rtf_document2 = function(...) {
  markdown_document2(..., base_format = rmarkdown::rtf_document)
}

#' @rdname html_document2
#' @export
word_document2 = function(...) {
  markdown_document2(..., base_format = rmarkdown::word_document)
}
