% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GOF_model_resample.R
\name{GOF_model_resample}
\alias{GOF_model_resample}
\title{R6 Class representing the resampling scheme for
Goodness-of-fit-tests for (linear) models}
\description{
Class is able to resample model fit, i.e. generate a
  new data set and refit the model to the new data.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{GOF_model_resample$new()}}
\item \href{#method-resample}{\code{GOF_model_resample$resample()}}
\item \href{#method-clone}{\code{GOF_model_resample$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GOF_model_resample$new(gof_model_simulator, gof_model_trainer)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{gof_model_simulator}}{an instance that implements \link{GOF_model_simulator}}

\item{\code{gof_model_trainer}}{an instance that implements \link{GOF_model_trainer}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
No explicit return
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-resample"></a>}}
\if{latex}{\out{\hypertarget{method-resample}{}}}
\subsection{Method \code{resample()}}{
resamples the dependent variable in \code{data} and refits
  \code{model} to that new data set
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GOF_model_resample$resample(model, data, y_name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{fitted model based on \code{data}}

\item{\code{data}}{used to fit \code{model}}

\item{\code{y_name}}{string specifying the name of the dependent variable}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a resampled version of \code{model}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GOF_model_resample$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
