% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoxCoxmix.R, R/summary.boxcoxmix.R
\name{np.boxcox}
\alias{np.boxcox}
\alias{vc.boxcox}
\alias{np.estep}
\alias{np.zk}
\alias{fik}
\alias{yhat}
\alias{ytrans}
\alias{np.bhat}
\alias{nb.se}
\alias{np.mstep}
\alias{np.em}
\alias{vc.estep}
\alias{bhat}
\alias{vc.se}
\alias{mik}
\alias{vc.mstep}
\alias{vc.em}
\alias{gqz}
\alias{np.theta}
\alias{vc.theta}
\alias{zk}
\alias{masspoint.class}
\title{Internal boxcoxmix functions}
\usage{
np.boxcox(
  formula,
  groups = 1,
  data,
  K = 3,
  tol = 0.5,
  lambda = 1,
  steps = 500,
  EMdev.change = 1e-04,
  plot.opt = 1,
  verbose = TRUE,
  start = "gq",
  ...
)

vc.boxcox(
  formula,
  groups = 1,
  data,
  K = 3,
  tol = 0.5,
  lambda = 1,
  steps = 500,
  EMdev.change = 1e-04,
  plot.opt = 1,
  verbose = TRUE,
  start = "gq",
  ...
)

np.em(
  y,
  x,
  K,
  lambda = 1,
  steps = 500,
  tol = 0.5,
  start = "gq",
  EMdev.change = 1e-04,
  plot.opt = 1,
  verbose = TRUE,
  ...
)

vc.em(
  y,
  x,
  sizes = 1,
  K,
  lambda,
  steps = 500,
  tol = 0.5,
  start = "gq",
  EMdev.change = 1e-04,
  plot.opt = 1,
  verbose = TRUE,
  ...
)

np.estep(y, x, lambda, p, beta, z, sigma)

vc.estep(Y, X, sizes = 1, lambda, p, beta, z, sigma)

np.mstep(y, x, beta, lambda, w)

vc.mstep(Y, X, sizes = 1, beta, lambda, w)

np.theta(y, x, lambda, beta, z)

vc.theta(Y, X, sizes, lambda, beta, z)

np.bhat(y, x, w, z, lambda)

bhat(Y, X, sizes, w, z, lambda)

np.zk(y, x, w, beta, lambda)

zk(Y, X, sizes, w, beta, lambda)

fik(y, x, lambda, beta, z, sigma)

mik(Y, X, sizes, lambda, beta, z, sigma)

yhat(v, lambda = 1)

ytrans(y, lambda = 1)

gqz(numnodes = 20, minweight = 1e-06)

masspoint.class(object)
}
\arguments{
\item{formula}{a formula describing the transformed response and the fixed
effect model (e.g. y ~ x).}

\item{groups}{the random effects. To fit overdispersion models , set \code{groups} = 1.}

\item{data}{a data frame containing variables used in the fixed and random
effect models.}

\item{K}{the number of mass points.}

\item{tol}{a positive scalar (usually, 0< \code{tol} <= 2)}

\item{lambda}{a transformation parameter, setting \code{lambda}=1 means 'no
transformation'.}

\item{steps}{maximum number of iterations for the EM algorithm.}

\item{EMdev.change}{a small scalar, with default 0.0001, used to determine
when to stop EM algorithm.}

\item{plot.opt}{Set plot.opt=1, to plot the disparity against
iteration number. Use \code{plot.opt=2} for \code{tolfind.boxcox} and \code{plot.opt=3}
for \code{optim.boxcox}.}

\item{verbose}{If set to FALSE, no printed output on progress.}

\item{start}{a description of the initial values to be used in the fitted
model, Quantile-based version "quantile" or Gaussian Quadrature "gq" can be
set.}

\item{\dots}{extra arguments will be ignored.}

\item{y}{..}

\item{x}{..}

\item{sizes}{..}

\item{p}{..}

\item{beta}{..}

\item{z}{..}

\item{sigma}{..}

\item{Y}{..}

\item{X}{..}

\item{w}{..}

\item{v}{..}

\item{numnodes}{..}

\item{minweight}{..}

\item{object}{..}
}
\description{
auxiliary functions are not intended to be directly called from the user.
}
\author{
Amani Almohaimeed and Jochen Einbeck
}
\keyword{em}
\keyword{internal}
