% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summerizeRes.R
\name{summerizePgmmRJMCMC}
\alias{summerizePgmmRJMCMC}
\title{summerizePgmmRJMCMC}
\usage{
summerizePgmmRJMCMC(pgmmResList, trueCluster = NULL)
}
\arguments{
\item{pgmmResList}{result list from pgmmRJMCMC}

\item{trueCluster}{true cluster allocation}
}
\description{
summerizePgmmRJMCMC
}
\examples{
library("fabMix")
library("mclust")
library("pgmm")
library("mvtnorm")
library("mcmcse")
library("MASS")
library("gtools")
n <- 50
p <- 10
q <- 4
K <- 10
syntheticDataset <- simData(
  sameLambda = TRUE, sameSigma = TRUE, K.true = K, n = n, q = q, p = p,
  sINV_values = 1 / ((1:p))
)
nsim <- 5
burn <- 0
X <- t(syntheticDataset$data)
qnew <- 4
Mstep <- 1
Vstep <- 1
constraint <- c(0, 0, 0)
mInit <- 20
mVec <- c(1, 20)
\donttest{
res <- pgmmRJMCMC(X, mInit, mVec, qnew,
  niter = nsim, burn = burn, constraint = constraint,
  Mstep = Mstep, Vstep = Vstep
)
}

\donttest{
summerizePgmmRJMCMC(res, syntheticDataset$class)
}
}
