% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bestBraidModel.R
\name{findBestBraid}
\alias{findBestBraid}
\alias{findBestBraid.formula}
\alias{findBestBraid.default}
\title{Select Best BRAID Response Fit}
\usage{
findBestBraid(
  formula,
  data,
  defaults,
  extended = FALSE,
  weights = NULL,
  start = NULL,
  direction = 0,
  lower = NULL,
  upper = NULL,
  prior = "moderate",
  getCIs = TRUE,
  useBIC = TRUE
)

\method{findBestBraid}{formula}(
  formula,
  data,
  defaults,
  extended = FALSE,
  weights = NULL,
  start = NULL,
  direction = 0,
  lower = NULL,
  upper = NULL,
  prior = "moderate",
  getCIs = TRUE,
  useBIC = TRUE
)

\method{findBestBraid}{default}(
  formula,
  data,
  defaults,
  extended = FALSE,
  weights = NULL,
  start = NULL,
  direction = 0,
  lower = NULL,
  upper = NULL,
  prior = "moderate",
  getCIs = TRUE,
  useBIC = TRUE
)
}
\arguments{
\item{formula}{Either an object of class \code{formula} such as would be provided
to a modeling function like \code{\link[stats:lm]{stats::lm()}}, or a width-2 numeric array vector
of concentration pairs (including 0 or Inf).  A formula should specify a
single output as a function of two inputs, eg. \code{activity ~ conc1 + conc2}.}

\item{data}{If \code{forumula} is a symbolic formula, a data frame containing the
specified values. If \code{formula} is a numeric array of concentrations, a
numeric vector of response values, the same length as the number of rows of
\code{formula}.}

\item{defaults}{Default minimal and maximal effect values used to fix effect
parameters during model selection.}

\item{extended}{Should models with an additional freely varying Ef parameter
be included.  If \code{FALSE} (the default), ten models in which the maximal
effect parameter Ef is constrained to be equal to one or more of the two
individual maximal effect parameters will be tested; if \code{TRUE}, an additional
two models in which Ef varies freely will be included.}

\item{weights}{A vector of weights (between 0 and 1) the same length as
the data which determines the weight with which each measurement
will impact the the sum of squared errors.  Weights will be multiplied by
errors \emph{before} squaring.  If \code{NULL} (the default) all weights will be set
to 1. Can be a numeric vector, or the name of a column in \code{data} if \code{formula}
is a symbolic formula}

\item{start}{A BRAID parameter vector specifying the first guess where the
non-linear optimization should begin.  May be a length 7, 8, or 9 vector,
though a full length vector is always preferable.  If \code{NULL} (the default),
it will be estimated from the data.}

\item{direction}{Determines the possible directionality of the BRAID
model.  If 0 (the default) no additional constraints are placed on the
parameters.  If greater than 0, the fitting will require that the maximal
effects are all \emph{greater} than or equal to the minimal effect.  If less
than 0, the fitting will require that all maximal effect is \emph{less} than or
equal to the minimal effect.}

\item{lower}{A numeric vector of lower bounds on the fitted parameter values.
May be the same length as the number of fitted parameters, or a full,
length-9 vector. Missing or unspecified lower bounds may be included as \code{NA}
or \code{Inf}; if unspecified, lower bounds on the first five parameters (IDMA,
IDMB, na, nb, and kappa) will be automatically estimated from the data.
Bounds on the minimal and maximal effect parameters however (E0, EfA, EfB,
and Ef) will be assumed to be infinite unless specified.  A value of \code{NULL},
the default, will be treated as all lower parameter bounds being
unspecified.}

\item{upper}{A numeric vector of upper bounds on the fitted parameter values.
Used in the same way as \code{lower}.}

\item{prior}{A character string specifying the desired Bayesian prior term
for kappa, or an object of class \code{kappaPrior} genererated by the function
\code{\link[=kappaPrior]{kappaPrior()}}.  Allowed strings are "mild", "moderate" (the default),
"high", or "none".  If a string is given, the kappa prior object will be
estimated from the data using an initial ten-parameter fit to approximate
measurement noise.}

\item{getCIs}{Should bootstrapped confidence intervals be estimated and
added to the BRAID fit object. Default value is \code{TRUE}.}

\item{useBIC}{If \code{TRUE} (the default), the best (read: most parsimonious)
model will be selected from all tested models using the Bayesian information
criterion (Schwarz 1978).  If \code{FALSE} the function will follow the convention
of earlier versions of the \code{braidrm} package and use the Akaike information
criterion (Akaike 1974).}
}
\value{
An object of class \code{braidrm}.  It will contain all the fields of a
standard \code{braidrm} object, and also an additional field, \code{allfits}
containing a summary of the best fit model from each of the 10 or 12
candidate models tested.
}
\description{
Picks the most parsimonious BRAID fit from a standard set of commonly used
variants
}
\details{
When fitting real experimental data, it is not uncommon for a measured
surface to contain such incomplete or noisy data that many of the parameters
are highly underdetermined.  Unfortunately, in such cases, non-linear
optimization can often resort to wildly implausible values to explain small
variations in the data. To address this, this function runs multiple BRAID
response fits, including some in which the minimal and maximal effect
parameters are constrained to reasonable default values, to test if
additional free parameters offer sufficiently improved fits to be included.

When the parameter \code{extended} is set to \code{FALSE}, the function runs ten BRAID
scenarios: five in which the minimal effect parameter is allowed to vary
freely, and five in which it is fixed at the first default value.  The five
tested models in each set represent five distinct configurations of the
maximal effect parameters:
\itemize{
\item Both maximal effects are fixed the same value (the second default)
\item Maximal effect EfA (and when it is larger, Ef) varies freely, but effect
EfB is fixed at the second default
\item Maximal effect EfB (and when it is larger, Ef) varies freely, but effect
EfA is fixed at the second default
\item The maximal effect Ef varies freely, and both EfA and EfB are constrained
to be equal to it
\item The maximal effects EfA and EfB both vary freely, and Ef is constrained to
be equal to the larger of the two
}

When \code{extended} is \code{TRUE}, two additional models (one with E0 fixed and one
in which it varies freely) are included, in which all three maximal effect
parameters are allowed to vary freely and independently.
}
\examples{
bfit1 <- findBestBraid(measure ~ concA + concB, additiveExample,
                       defaults=c(0,1))
summary(bfit1)
length(bfit1$allfits)

bfit2 <- findBestBraid(measure ~ concA + concB, additiveExample,
                       defaults=c(0,2), extended=TRUE, getCIs = FALSE)
summary(bfit2)
length(bfit2$allfits)
}
\references{
Akaike, Hirotugu. 1974. “A New Look at the Statistical Model Identification.”
\emph{IEEE Transactions on Automatic Control} \strong{19} (6): 716–23.

Schwarz, Gideon. 1978. “Estimating the Dimension of a Model.”
\emph{The Annals of Statistics}, 461–64.
}
