% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_boot.R
\name{plot_boot}
\alias{plot_boot}
\title{Plot global graph measures with shaded regions calculated from bootstrapping}
\usage{
plot_boot(boot.dt, ylabel = NULL, alpha = 0.4, ...)
}
\arguments{
\item{boot.dt}{A \code{data.table} output from \code{\link{boot_global}}}

\item{ylabel}{A character string to place on the y-axis label (default: NULL)}

\item{alpha}{A numeric indicating the opacity for
\code{\link[ggplot2]{geom_ribbon}}}

\item{...}{Other parameters passed to \code{\link[ggplot2]{geom_ribbon}}}
}
\value{
A list with the following elements:
\item{p1}{A ggplot object with ribbon representing standard error}
\item{p2}{A ggplot object with ribbon representing 95\% confidence interval}
}
\description{
This function takes a list of \code{\link[boot]{boot}} objects (the number of
elements equals the number of subject groups) and plots the observed value
across all graph densities. It returns a list containing: a
\code{\link{data.table}} with standard errors and 95\% confidence intervals
at each density, and 2 \code{\link[ggplot2]{ggplot}} objects with shaded
regions surrounding the observed values.
}
\details{
The 95\% confidence intervals are calculated using the normal approximation.
}
\examples{
\dontrun{
boot.mod.plots <- plot_boot(boot.mod$dt, ylab='Modularity')
}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\seealso{
\code{\link{boot_global}}
}

