% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rich_club_coeff.R
\name{rich.club.coeff}
\alias{rich.club.coeff}
\title{Calculate the rich club of a graph}
\usage{
rich.club.coeff(g, k = 1, weighted = FALSE)
}
\arguments{
\item{g}{The graph of interest}

\item{k}{The minimum degree for including a vertex (default: 1)}

\item{weighted}{A logical indicating whether or not edge weights should be
used (default: FALSE)}
}
\value{
A list with the following components:
\item{phi}{The rich club coefficient, \eqn{\phi}.}
\item{graph}{A subgraph containing only the rich club nodes.}
\item{Nk}{The number of vertices in the rich club graph.}
\item{Ek}{The number of edges in the rich club graph.}
}
\description{
This function calculates the rich club of a graph, both the coefficient
\eqn{\phi} and the nodes that make up this subgraph.
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\references{
Zhou S., Mondragon R.J. (2004) \emph{The rich-club phenomenon
in the internet topology}. IEEE Comm Lett, 8:180-182.

Opsahl T., Colizza V., Panzarasa P., Ramasco J.J. (2008)
\emph{Prominence and control: the weighted rich-club effect}. Physical Review
Letters, 101.16:168702.
}
\seealso{
\code{\link{rich.club.norm}}
}

