% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permute_group.R
\name{brainGraph_permute}
\alias{brainGraph_permute}
\alias{summary.brainGraph_permute}
\alias{plot.brainGraph_permute}
\title{Permutation test for group difference of graph measures}
\usage{
brainGraph_permute(densities, resids, N = 5000, perms = NULL,
  auc = FALSE, level = c("graph", "vertex", "other"),
  measure = c("btwn.cent", "degree", "E.nodal", "ev.cent", "knn",
  "transitivity", "vulnerability"), atlas = resids$atlas,
  .function = NULL)

\method{summary}{brainGraph_permute}(object, measure = NULL,
  alternative = c("two.sided", "less", "greater"), alpha = 0.05,
  p.sig = c("p", "p.fdr"), ...)

\method{plot}{brainGraph_permute}(x, measure = NULL,
  alternative = c("two.sided", "less", "greater"), alpha = 0.05,
  p.sig = c("p", "p.fdr"), ptitle = NULL, ...)
}
\arguments{
\item{densities}{Numeric vector of graph densities}

\item{resids}{An object of class \code{brainGraph_resids} (the output from
\code{\link{get.resid}})}

\item{N}{Integer; the number of permutations (default: 5e3)}

\item{perms}{Numeric matrix of permutations, if you would like to provide
your own (default: \code{NULL})}

\item{auc}{Logical indicating whether or not to calculate differences in the
area-under-the-curve of metrics (default: \code{FALSE})}

\item{level}{A character string for the attribute \dQuote{level} to calculate
differences (default: \code{graph})}

\item{measure}{A character string specifying the vertex-level metric to
calculate, only used if \code{level='vertex'} (default: \code{btwn.cent}).
For the \code{summary} method, this is to focus on a single
\emph{graph-level} measure (since multiple are calculated at once).}

\item{atlas}{Character string of the atlas name; required if
\code{level='graph'}}

\item{.function}{A custom function you can pass if \code{level='other'}}

\item{object, x}{A \code{brainGraph_permute} object (output by
\code{\link{brainGraph_permute}}).}

\item{alternative}{Character string, whether to do a two- or one-sided test.
Default: \code{'two.sided'}}

\item{alpha}{Numeric; the significance level. Default: 0.05}

\item{p.sig}{Character string specifying which p-value to use for displaying
significant results (default: \code{p})}

\item{...}{Unused}

\item{ptitle}{Character string specifying a title for the plot (default:
\code{NULL})}
}
\value{
An object of class \code{brainGraph_permute} with input arguments in
  addition to:
  \item{DT}{A data table with permutation statistics}
  \item{obs.diff}{A data table of the observed group differences}
  \item{Group}{Group names}

The \code{plot} method returns a \emph{list} of \code{ggplot} objects
}
\description{
\code{brainGraph_permute} draws permutations from linear model residuals to
determine the significance of between-group differences of a global or
vertex-wise graph measure. It is intended for structural covariance networks
(in which there is only one graph per group), but can be extended to other
types of data.
}
\details{
If you would like to calculate differences in the area-under-the-curve (AUC)
across densities, then specify \code{auc=TRUE}.

There are three possible \dQuote{levels}:
\enumerate{
  \item \emph{graph} Calculate modularity (Louvain algorithm), clustering
  coefficient, characteristic path length, degree assortativity, global
  efficiency, lobe assortativity, and edge asymmetry.
  \item \emph{vertex} Choose one of: betweenness centrality, degree, nodal
  efficiency, k-nearest neighbor degree, transitivity, or vulnerability.
  \item \emph{other} Supply your own function. This is useful if you want to
  calculate something that I haven't hard-coded. It must take as its own
  arguments: \code{g} (a list of lists of \code{igraph} graph objects); and
  \code{densities} (numeric vector).
}
}
\examples{
\dontrun{
myResids <- get.resid(lhrh, covars)
myPerms <- shuffleSet(n=nrow(myResids$resids.all), nset=1e3)
out <- brainGraph_permute(densities, m, perms=myPerms, atlas='dk')
out <- brainGraph_permute(densities, m, perms=myPerms, level='vertex')
out <- brainGraph_permute(densities, m, perms=myPerms,
  level='other', .function=myFun)
}
}
\seealso{
Other Group analysis functions: \code{\link{Bootstrapping}},
  \code{\link{GLM}}, \code{\link{Mediation}},
  \code{\link{NBS}}, \code{\link{mtpc}}

Other Structural covariance network functions: \code{\link{Bootstrapping}},
  \code{\link{IndividualContributions}},
  \code{\link{Residuals}}, \code{\link{corr.matrix}},
  \code{\link{import_scn}}, \code{\link{plot_volumetric}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\concept{Group analysis functions}
\concept{Structural covariance network functions}
