% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list.R
\name{Creating_Graphs_GLM}
\alias{Creating_Graphs_GLM}
\alias{make_brainGraphList.bg_GLM}
\alias{make_brainGraphList.mtpc}
\alias{make_brainGraphList.NBS}
\title{Create a graph list with GLM-specific attributes}
\usage{
\method{make_brainGraphList}{bg_GLM}(x, atlas = x$atlas,
  type = "observed", level = "contrast", set.attrs = FALSE,
  modality = NULL, weighting = NULL, threshold = NULL,
  gnames = x$con.name, ...)

\method{make_brainGraphList}{mtpc}(x, atlas, type = "observed",
  level = "contrast", set.attrs = FALSE, modality = NULL,
  weighting = NULL, threshold = NULL, gnames = x$con.name, ...)

\method{make_brainGraphList}{NBS}(x, atlas, type = "observed",
  level = "contrast", set.attrs = TRUE, modality = NULL,
  weighting = NULL, threshold = NULL, gnames = x$con.name,
  mode = "undirected", weighted = TRUE, diag = FALSE, ...)
}
\arguments{
\item{x}{A \code{bg_GLM}, \code{mtpc}, or \code{NBS} object}

\item{atlas}{Character string specifying the brain atlas to use}

\item{type}{Character string indicating the type of graphs. Default:
\code{observed}}

\item{level}{Character string indicating whether the graphs are subject-,
group-, or contrast-specific. Default: \code{'subject'}}

\item{set.attrs}{Logical indicating whether to assign all graph-, vertex-,
and edge-level attributes (via \code{\link{set_brainGraph_attr}}). Default:
\code{TRUE}}

\item{modality}{Character string indicating imaging modality (e.g. 'dti').
Default: \code{NULL}}

\item{weighting}{Character string indicating how the edges are weighted
(e.g., 'fa', 'pearson', etc.). Default: \code{NULL}}

\item{threshold}{Numeric indicating the threshold used when sparsifying the
connectivity matrix (if any). Default: \code{NULL}}

\item{gnames}{Character vector of graph names (e.g., study IDs if
\code{level='subject'}). Default: \code{NULL}}

\item{...}{Other arguments passed to \code{\link{set_brainGraph_attr}}}

\item{mode}{Character string defining how the matrix should be interpreted.
Default: \code{'undirected'}}

\item{weighted}{Logical specifying whether to create a weighted network}

\item{diag}{Logical indicating whether to include the diagonal of the
connectivity matrix. Default: \code{FALSE}}
}
\value{
A \code{brainGraphList} object, with a graph object for each contrast
  with additional attributes:
  \item{Graph}{\emph{name} (contrast name), \emph{outcome} (the outcome
    variable), \emph{alpha} (the significance level); for MTPC:
    \emph{tau.mtpc}, \emph{S.mtpc}, \emph{S.crit}, \emph{A.crit}}
  \item{Vertex}{\emph{size2} (t-statistic); \emph{size} (the t-stat
    transformed for visualization purposes); \emph{p} (equal to \eqn{1-p});
    \emph{p.fdr} (equal to \eqn{1-p_{FDR}}, the FDR-adjusted p-value);
    \emph{effect.size} (the contrast of parameter estimates for t-contrasts;
    the extra sum of squares for F-contrasts); \emph{se} (the
    standard error of \emph{gamma}); \emph{A.mtpc}, \emph{sig} (binary
    indicating whether \code{A.mtpc > A.crit}) (for MTPC)}

\code{make_brainGraphList.NBS} returns graphs with additional
  attributes:
  \item{Vertex}{\emph{comp} (integer vector indicating connected component
    membership), \emph{p.nbs} (P-value for each component)}
  \item{Edge}{\emph{stat} (the test statistic for each connection), \emph{p}
    (the P-value)}
}
\description{
These methods create a \code{brainGraphList} with attributes specific to the
results of \code{\link{brainGraph_GLM}}, \code{\link{mtpc}}, or
\code{\link{NBS}}. The \code{graphs} element of the returned object will
contain one graph for each contrast.
}
\note{
Only valid for \emph{vertex}-level and \emph{NBS} analyses.
}
\seealso{
\code{\link{brainGraph_GLM}, \link{mtpc}, \link{NBS}}

Other Graph creation functions: \code{\link{Creating_Graphs}},
  \code{\link{brainGraphList}},
  \code{\link{make_ego_brainGraph}}
}
\concept{Graph creation functions}
