% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_graphs.R
\name{make_ego_brainGraph}
\alias{make_ego_brainGraph}
\title{Create a graph of the union of multiple vertex neighborhoods}
\usage{
make_ego_brainGraph(g, vs)
}
\arguments{
\item{g}{An \code{igraph} graph object}

\item{vs}{Either a character or integer vector (vertex names or indices,
respectively) for the vertices of interest}
}
\value{
An \code{igraph} graph object containing the union of all edges and
  vertices in the neighborhoods of the input vertices; only the vertex
  attribute \emph{name} will be present
}
\description{
This function accepts multiple vertices, creates graphs of their
neighborhoods (of order 1), and returns the union of those graphs.
}
\examples{
\dontrun{
subg <- make_ego_brainGraph(g1[[N]], c(24, 58))
subg <- make_ego_brainGraph(g1[[N]], c('lPCUN', 'rPCUN'))
}
}
\seealso{
\code{\link[igraph]{ego}}

Other Graph creation functions: \code{\link{Creating_Graphs_GLM}},
  \code{\link{Creating_Graphs}},
  \code{\link{brainGraphList}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\concept{Graph creation functions}
