% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-structures.R
\name{new_cluster}
\alias{new_cluster}
\title{New Cluster}
\usage{
new_cluster(
  num_workers,
  spark_version,
  node_type_id,
  driver_node_type_id = NULL,
  autoscale = NULL,
  cloud_attrs = NULL,
  spark_conf = NULL,
  spark_env_vars = NULL,
  custom_tags = NULL,
  ssh_public_keys = NULL,
  log_conf = NULL,
  init_scripts = NULL,
  enable_elastic_disk = TRUE,
  driver_instance_pool_id = NULL,
  instance_pool_id = NULL,
  kind = c("CLASSIC_PREVIEW"),
  data_security_mode = c("NONE", "SINGLE_USER", "USER_ISOLATION", "LEGACY_TABLE_ACL",
    "LEGACY_PASSTHROUGH", "LEGACY_SINGLE_USER", "LEGACY_SINGLE_USER_STANDARD",
    "DATA_SECURITY_MODE_STANDARD", "DATA_SECURITY_MODE_DEDICATED",
    "DATA_SECURITY_MODE_AUTO")
)
}
\arguments{
\item{num_workers}{Number of worker nodes that this cluster should have. A
cluster has one Spark driver and \code{num_workers} executors for a total of
\code{num_workers} + 1 Spark nodes.}

\item{spark_version}{The runtime version of the cluster. You can retrieve a
list of available runtime versions by using \code{\link[=db_cluster_runtime_versions]{db_cluster_runtime_versions()}}.}

\item{node_type_id}{The node type for the worker nodes.
\code{\link[=db_cluster_list_node_types]{db_cluster_list_node_types()}} can be used to see available node types.}

\item{driver_node_type_id}{The node type of the Spark driver. This field is
optional; if unset, the driver node type will be set as the same value as
\code{node_type_id} defined above. \code{\link[=db_cluster_list_node_types]{db_cluster_list_node_types()}} can be used to
see available node types.}

\item{autoscale}{Instance of \code{\link[=cluster_autoscale]{cluster_autoscale()}}.}

\item{cloud_attrs}{Attributes related to clusters running on specific cloud
provider. Defaults to \code{\link[=aws_attributes]{aws_attributes()}}. Must be one of \code{\link[=aws_attributes]{aws_attributes()}},
\code{\link[=azure_attributes]{azure_attributes()}}, \code{\link[=gcp_attributes]{gcp_attributes()}}.}

\item{spark_conf}{Named list. An object containing a set of optional,
user-specified Spark configuration key-value pairs. You can also pass in a
string of extra JVM options to the driver and the executors via
\code{spark.driver.extraJavaOptions} and \code{spark.executor.extraJavaOptions}
respectively. E.g. \code{list("spark.speculation" = true, "spark.streaming.ui.retainedBatches" = 5)}.}

\item{spark_env_vars}{Named list. User-specified environment variable
key-value pairs. In order to specify an additional set of
\code{SPARK_DAEMON_JAVA_OPTS}, we recommend appending them to
\verb{$SPARK_DAEMON_JAVA_OPTS} as shown in the following example. This ensures
that all default Databricks managed environmental variables are included as
well. E.g. \code{{"SPARK_DAEMON_JAVA_OPTS": "$SPARK_DAEMON_JAVA_OPTS -Dspark.shuffle.service.enabled=true"}}}

\item{custom_tags}{Named list. An object containing a set of tags for cluster
resources. Databricks tags all cluster resources with these tags in addition
to \code{default_tags}. Databricks allows at most 45 custom tags.}

\item{ssh_public_keys}{List. SSH public key contents that will be added to each
Spark node in this cluster. The corresponding private keys can be used to
login with the user name ubuntu on port 2200. Up to 10 keys can be specified.}

\item{log_conf}{Instance of \code{\link[=cluster_log_conf]{cluster_log_conf()}}.}

\item{init_scripts}{Instance of \code{\link[=init_script_info]{init_script_info()}}.}

\item{enable_elastic_disk}{When enabled, this cluster will dynamically
acquire additional disk space when its Spark workers are running low on
disk space.}

\item{driver_instance_pool_id}{ID of the instance pool to use for the
driver node. You must also specify \code{instance_pool_id}. Optional.}

\item{instance_pool_id}{ID of the instance pool to use for cluster nodes. If
\code{driver_instance_pool_id} is present, \code{instance_pool_id} is used for worker
nodes only. Otherwise, it is used for both the driver and worker nodes.
Optional.}

\item{kind}{The kind of compute described by this compute specification.}

\item{data_security_mode}{Data security mode decides what data governance
model to use when accessing data from a cluster.}
}
\description{
New Cluster
}
\seealso{
\code{\link[=job_task]{job_task()}}

Other Task Objects: 
\code{\link{condition_task}()},
\code{\link{email_notifications}()},
\code{\link{for_each_task}()},
\code{\link{libraries}()},
\code{\link{notebook_task}()},
\code{\link{pipeline_task}()},
\code{\link{python_wheel_task}()},
\code{\link{run_job_task}()},
\code{\link{spark_jar_task}()},
\code{\link{spark_python_task}()},
\code{\link{spark_submit_task}()},
\code{\link{sql_file_task}()},
\code{\link{sql_query_task}()}
}
\concept{Task Objects}
