% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jobs.R
\name{db_jobs_runs_submit}
\alias{db_jobs_runs_submit}
\title{Create And Trigger A One-Time Run}
\usage{
db_jobs_runs_submit(
  tasks,
  run_name,
  timeout_seconds = NULL,
  idempotency_token = NULL,
  access_control_list = NULL,
  git_source = NULL,
  job_clusters = NULL,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{tasks}{Task specifications to be executed by this job. Use
\code{\link[=job_tasks]{job_tasks()}}.}

\item{run_name}{Name for the run.}

\item{timeout_seconds}{An optional timeout applied to each run of this job.
The default behavior is to have no timeout.}

\item{idempotency_token}{An optional token that can be used to guarantee the
idempotency of job run requests. If an active run with the provided token
already exists, the request does not create a new run, but returns the ID of
the existing run instead. If you specify the idempotency token, upon failure
you can retry until the request succeeds. Databricks guarantees that exactly
one run is launched with that idempotency token. This token must have at most
64 characters.}

\item{access_control_list}{Instance of \code{\link[=access_control_request]{access_control_request()}}.}

\item{git_source}{Optional specification for a remote repository containing
the notebooks used by this job's notebook tasks. Instance of \code{\link[=git_source]{git_source()}}.}

\item{job_clusters}{Named list of job cluster specifications (using
\code{\link[=new_cluster]{new_cluster()}}) that can be shared and reused by tasks of this job.
Libraries cannot be declared in a shared job cluster. You must declare
dependent libraries in task settings.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\description{
Create And Trigger A One-Time Run
}
\seealso{
Other Jobs API: 
\code{\link{db_jobs_create}()},
\code{\link{db_jobs_delete}()},
\code{\link{db_jobs_get}()},
\code{\link{db_jobs_list}()},
\code{\link{db_jobs_repair_run}()},
\code{\link{db_jobs_reset}()},
\code{\link{db_jobs_run_now}()},
\code{\link{db_jobs_runs_cancel}()},
\code{\link{db_jobs_runs_delete}()},
\code{\link{db_jobs_runs_export}()},
\code{\link{db_jobs_runs_get}()},
\code{\link{db_jobs_runs_get_output}()},
\code{\link{db_jobs_runs_list}()},
\code{\link{db_jobs_update}()}
}
\concept{Jobs API}
