# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Train a random forest
#' 
#' This function is not intended for end users. Users should use the brif.formula or brif.default function. 
#' 
#' @param rdf a data frame. The first column is treated as the target variable. 
#' @param par a list containing all parameters. 
#' @return a list, of class "brif", containing the trained random forest model.
rftrain <- function(rdf, par) {
    .Call('_brif_rftrain', PACKAGE = 'brif', rdf, par)
}

#' Predict new cases
#' 
#' This function is not intended for end users. Users should use the predict.brif function instead.
#' 
#' @param rf an object of class 'brif', as returned by rftrain.
#' @param rdf a data frame containing the new cases to be predicted.
#' @param vote_method an integer (0 or 1) indicating the voting mechanism among leaf predictions.
#' @param nthreads an integer specifying the number of threads to be used in prediction.
#' @return a data frame containing the predicted values.
rfpredict <- function(rf, rdf, vote_method, nthreads) {
    .Call('_brif_rfpredict', PACKAGE = 'brif', rf, rdf, vote_method, nthreads)
}

#' Print the decision rules of a Brif tree
#' 
#' @param rf an object of class 'brif', as returned by rftrain.
#' @param which_tree an integer indicating the tree number 
#' @return No return value. The function is intended for producing a side effect, which prints the decision rules to the standard output.  
printBrifTree <- function(rf, which_tree) {
    invisible(.Call('_brif_printBrifTree', PACKAGE = 'brif', rf, which_tree))
}

#' Train a model and predict for newdata in one go
#' 
#' This function is not intended for end users. Users should use the function brif or brif.trainpredict and supply the newdata argument thereof. 
#' @param rdf a data frame containing the training data.
#' @param rdf_new a data frame containing new cases to be predicted.
#' @param par a list containing all parameters.
#' @return a data frame containing the predicted values.
rftrainpredict <- function(rdf, rdf_new, par) {
    .Call('_brif_rftrainpredict', PACKAGE = 'brif', rdf, rdf_new, par)
}

