% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Landscape-Individuals-Methods.R
\docType{methods}
\name{plot,Landscape,Individuals-method}
\alias{plot,Landscape,Individuals-method}
\title{plot Landscape & Individuals method}
\usage{
\S4method{plot}{Landscape,Individuals}(x, y, time = -1, objectT = NULL,
  numind = -1, add = F, ..., plot.legend = TRUE)
}
\arguments{
\item{x}{A Landscape object}

\item{y}{An Individuals object}

\item{time}{Time selection (default = -1) for Toxic intensity}

\item{objectT}{ToxicIntensityRaster, 3D array (result of \link{toxicIntensity}, default NULL)}

\item{numind}{an individual ID}

\item{add}{Boolean to draw hover an another plot}

\item{...}{default plot parameters (par)}

\item{plot.legend}{plot legend (default TRUE)}
}
\description{
Plots using Landscape & Individuals objects.
}
\details{
If objectT and numind are informed, the function will draw an individual ecoToxical plot.

 If objectT and time are specified, the function will draw the landscape, the individuals states and the toxic intensity at this time of the simulation.
 
 By default this function will draw the landscape and the individuals positions.
}
\examples{
\dontrun{
data(maize_65)
# plot a landscape and individuals
plot(maize.landscape,maize.individuals)
# plot a landscape and individuals states at time 30
plot(maize.landscape,maize.individuals,time=30)
# Simulate pollen dispersion
tox <- toxicIntensity(maize.landscape,maize.emitted_pollen,1,61)
# plot a landscape, individuals and pollen dispersion of maize_65 data
plot(maize.landscape,maize.individuals,time=30,objectT=tox)
# plot ecotoxicology of individual 1.
ind2<-ecoToxic(maize.landscape,maize.individuals,objectT=tox,maxtime=61)
plot(maize.landscape,ind2,objectT=tox,numind=1)
}
}
