% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brm_data.R
\name{brm_data}
\alias{brm_data}
\title{Create and preprocess an MMRM dataset.}
\usage{
brm_data(
  data,
  outcome = "CHG",
  role = "change",
  baseline = NULL,
  group = "TRT01P",
  subgroup = NULL,
  time = "AVISIT",
  patient = "USUBJID",
  covariates = character(0L),
  missing = NULL,
  reference_group = "Placebo",
  level_control = NULL,
  reference_subgroup = NULL,
  reference_time = NULL,
  level_baseline = NULL
)
}
\arguments{
\item{data}{Data frame or tibble with longitudinal data.}

\item{outcome}{Character of length 1, name of the outcome variable.}

\item{role}{Character of length 1. Either \code{"response"} if \code{outcome}
is the raw response variable (e.g. AVAL) or \code{"change"} if \code{outcome}
is change from baseline (e.g. CHG).}

\item{baseline}{Character of length 1,
name of the baseline response variable.
Only relevant if the response variable is change from baseline.
Supply \code{NULL} to ignore or omit.}

\item{group}{Character of length 1, name of the treatment group variable.
Must point to a character vector in the data. Factors are converted
to characters.}

\item{subgroup}{Character of length 1, optional name of the a
discrete subgroup variable. Set to \code{NULL} to omit the subgroup (default).}

\item{time}{Character of length 1, name of the discrete time variable.
Must point to a character vector in the data. Factors are converted
to characters.}

\item{patient}{Character of length 1, name of the patient ID variable.}

\item{covariates}{Character vector of names of other covariates.}

\item{missing}{Character of length 1, name of an optional variable
in a simulated dataset to indicate which outcome values should be missing.
Set to \code{NULL} to omit.}

\item{reference_group}{Character of length 1, Level of the \code{group} column
to indicate the control group.
\code{reference_group} only applies to the post-processing that happens
in functions like \code{\link[=brm_marginal_draws]{brm_marginal_draws()}} downstream of the model.
It does not control the fixed effect parameterization in the
model matrix that \code{brms} derives from the formula from \code{brm_formula()}.}

\item{level_control}{Deprecated on 2024-01-11 (version 0.2.0.9002).
Use \code{reference_group} instead.}

\item{reference_subgroup}{Character of length 1,
level of the \code{subgroup} column
to use as a reference for pairwise differences in when computing
marginal means downstream of the model.
It does not control the fixed effect parameterization in the
model matrix that \code{brms} derives from the formula from \code{brm_formula()}.}

\item{reference_time}{Character of length 1 or \code{NULL},
level of the \code{time} column to indicate the baseline time point.
This value should not be present in the data if the outcome
variable is change from baseline, but it must be in the data
if the outcome variable is the raw response so that \code{brms.mmrm}
can produce model-based marginal estimates of change from baseline.
In other words, set \code{reference_time} to \code{NULL} if \code{role} is \code{"change"},
and set \code{reference_time} to a non-null value in \code{data[[time]]}
if \code{role} is \code{"response"}.

Note: \code{reference_time} only applies to the post-processing that happens
in functions like \code{\link[=brm_marginal_draws]{brm_marginal_draws()}} downstream of the model.
It does not control the fixed effect parameterization in the
model matrix that \code{brms} derives from the formula from \code{brm_formula()}.}

\item{level_baseline}{Deprecated on 2024-01-11 (version 0.2.0.9002).
Use \code{reference_time} instead.}
}
\value{
A classed tibble with attributes which denote features of
the data such as the treatment group and discrete time variables.
}
\description{
Create a dataset to analyze with an MMRM.
}
\section{Preprocessing}{

The preprocessing steps in \code{brm_data()} are as follows:
\itemize{
\item Perform basic assertions to make sure the data and other arguments
are properly formatted.
\item Convert the group and time columns to character vectors.
\item Sanitize the levels of the group and time columns using
\code{make.names(unique = FALSE, allow_ = TRUE)} to ensure agreement
between the data and the output of \code{brms}.
\item For each implicitly missing outcome observation, add explicit row
with the outcome variable equal to \code{NA_real_}.
\item Arrange the rows of the data by group, then patient, then discrete time.
\item Select only the columns of the data relevant to an MMRM analysis.
}
}

\section{Separation string}{

Post-processing in \code{\link[=brm_marginal_draws]{brm_marginal_draws()}} names each of the
group-by-time marginal means with the delimiting character string
from \code{Sys.getenv("BRM_SEP", unset = "|")}. Neither the column names
nor element names of the group and time variables can contain
this string. To set a custom string yourself, use
\code{Sys.setenv(BRM_SEP = "YOUR_CUSTOM_STRING")}.
}

\examples{
set.seed(0)
data <- brm_simulate_simple()$data
colnames(data) <- paste0("col_", colnames(data))
data
brm_data(
  data = data,
  outcome = "col_response",
  role = "response",
  group = "col_group",
  time = "col_time",
  patient = "col_patient",
  reference_group = "group_1",
  reference_time = "time_1"
)
}
\seealso{
Other data: 
\code{\link{brm_data_change}()}
}
\concept{data}
